<?php

namespace Modules\General\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Modules\Main\Models\Country;
use Modules\Main\Models\Category;
use Modules\Main\Models\Store;
use Modules\Main\Models\Coupon;
use Modules\Main\Models\Customer;
use Validator;
class DashboardController extends Controller
{
    /**
     * Display home page.
     *
     * @return \Illuminate\Http\Response
     */
    public function home()
    {
        $countries = Country::active()->with('stores')->get();
        $categories = Category::active()->with('stores')->get();

        $countStores = Store::get()->count('stores_id');
        $countCoupons = Coupon::active()->get()->count('coupons_id');
        $countCustomers = Customer::active()->get()->count('customers_id');
        $countCategories = Category::active()->get()->count('categories_id');
        return view('general::admin.dashboard.home',compact('countries','categories','countStores','countCoupons','countCustomers','countCategories'));
    }

}
