<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateStoreCountriesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection('mysql')->create('store_countries', function (Blueprint $table) {
            $table->bigIncrements('stores_countries_id');
            $table->unsignedBigInteger('stores_id');
            $table->unsignedBigInteger('countries_id');
            $table->foreign('stores_id')->references('stores_id')->on('stores')->onUpdate('cascade')->onDelete('cascade');
            $table->foreign('countries_id')->references('countries_id')->on('countries')->onUpdate('cascade')->onDelete('cascade');
            $table->charset = 'utf8mb4';
            $table->collation = 'utf8mb4_unicode_ci';
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('store_countries');
    }
}
