<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateCurrencyTranslationsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection('mysql')->create('currency_translations', function (Blueprint $table) {
            $table->bigIncrements('currencies_trans_id');
            $table->unsignedBigInteger('currencies_id');
            $table->string('locale',2)->nullable();
            $table->string('currencies_name')->nullable();
            $table->foreign('currencies_id')->references('currencies_id')->on('currencies')->onUpdate('cascade')->onDelete('cascade');
            $table->charset = 'utf8mb4';
            $table->collation = 'utf8mb4_unicode_ci';
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('currency_translations');
    }
}
