<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateSponsorsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection('mysql')->create('sponsors', function (Blueprint $table) {
            $table->bigIncrements('sponsors_id');
            $table->string('sponsors_name',255)->nullable();
            $table->string('sponsors_url',255)->nullable();
            $table->string('sponsors_email',255)->nullable();
            $table->string('sponsors_phone',255)->nullable();
            $table->unsignedBigInteger('countries_id')->nullable();
            
            $table->timestamp('sponsors_created_at')->default(\DB::raw('CURRENT_TIMESTAMP'));
            $table->timestamp('sponsors_updated_at')->default(\DB::raw('CURRENT_TIMESTAMP'));

            $table->foreign('countries_id')->references('countries_id')->on('countries')->cascadeOnUpdate()->nullOnDelete();

            $table->charset = 'utf8mb4';
            $table->collation = 'utf8mb4_unicode_ci';
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('sponsors');
    }
}
