<?php

namespace Modules\Main\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Modules\Main\Http\Requests\CurrencyRequest;

use Modules\Main\Models\Currency;

class CurrenciesController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $searchArray = [
            'currency_translations.currencies_name' => [request('title'), 'like'],
            'currencies.currencies_code' => [request('code'), 'like'],
        ];
        request()->flash();

        $query = Currency::join('currency_translations', 'currencies.currencies_id', 'currency_translations.currencies_id')
        ->groupBy('currencies.currencies_id');

        $searchQuery = $this->searchIndex($query, $searchArray);
        $currencies = $searchQuery->paginate(env('PerPage'));
        return view('main::admin.currencies.index', compact('currencies'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('main::admin.currencies.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Modules\General\Http\Requests\AdminRequest  $request
     * @return \Illuminate\Http\Response
     */
    public function store(CurrencyRequest $request)
    {
        $currency = Currency::create($request->all());
        return redirect()->route('admin.currencies.index')->with('status', __('main::lang.currencyCreated'));
    }

    /**
     * Display the specified resource.
     *
     * @param  \Modules\General\Models\Currency  $currency
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $currency = Currency::find($id);
        return view('main::admin.currencies.show', compact('currency'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \Modules\General\Models\Currency  $currency
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $currency = Currency::find($id);
        return view('main::admin.currencies.edit', compact('currency'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Modules\General\Http\Requests\AdminRequest  $request
     * @param  \Modules\General\Models\Admin  $admin
     * @return \Illuminate\Http\Response
     */
    public function update(CurrencyRequest $request, Currency $currency)
    {
        $currency->update($request->all());
        return redirect()->route('admin.currencies.index')->with('status', __('main::lang.currencyUpdated'));
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \Modules\General\Models\Admin  $admin
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $currency = Currency::find($id);
        $currency->delete();
        return back()->with('status', __('main::lang.currencyDeleted'));
    }

    public function changeStatus($id, $status)
    {
        $currency = Currency::find($id);
        if($currency){
            $currency->currencies_status = $status ;
            $currency->save();
        }
        return response(['msg' =>  __('main::lang.currencyUpdated')], 200);
    }

}
