<?php

namespace Modules\Main\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Modules\Main\Http\Requests\CustomerNotificationRequest;
use App\Notifications\Notifications ;
use App\Http\Traits\SendNotification;
use Modules\Main\Models\CustomerNotification;
use Modules\Main\Models\Customer;
use Modules\Main\Models\Store;
use Modules\Main\Models\Country;
use Modules\General\Models\Admin;
use Illuminate\Http\Request;
use Carbon\Carbon;
use DB;
class CustomersNotificationsController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {

        $searchArray = [
            'customers_notifications_text' => [request('text'), 'like'],
            'customers_notifications_pattern' => [request('pattern'), '='],
            'customers_notifications_type' => [request('type'), '='],
            'admins_id' => [request('admin'), '=']
        ];
        request()->flash();
        $query = CustomerNotification::orderBy('customers_notifications_id','desc');

        $searchQuery = $this->searchIndex($query, $searchArray);

        $customers_notifications = $searchQuery->paginate(env('PerPage'));

        $admins = Admin::get()->pluck('admins_name','admins_id');
        $countries  = Country::get()->pluck('countries_name','countries_id') ;

        return view('main::admin.customers_notifications.index', compact('customers_notifications','admins','countries'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $customers  = Customer::active()->pluck('customers_name','customers_id') ;
        $stores  = Store::get()->pluck('stores_name','stores_id') ;
        $countries  = Country::get()->pluck('countries_name','countries_id') ;

        return view('main::admin.customers_notifications.create',compact('countries','stores','customers'));
    }

  
    public function store(CustomerNotificationRequest $request)
    {
      
        if($request->customers_notifications_type == 'some'){
            $customers = Customer::active()->orderBy('customers_id')->whereIn('customers_id',$request->customers_notifications_customers)->get() ;
        }elseif($request->customers_notifications_type == 'gender'){
            $customers = Customer::active()->where('customers_gender',$request->customers_gender)->orderBy('customers_id')->get();
        }elseif($request->customers_notifications_type == 'country'){
            $customers = Customer::active()->where('countries_id',$request->countries_id)->orderBy('customers_id')->get();
        }else{
            $customers = Customer::active()->orderBy('customers_id')->get();
        }
   
        if(sizeof($customers) > 0){
            if($request->customers_notifications_action == 'deep_link'){
                $request['customers_notifications_action_value'] = $request->stores_id ;
            }
            if($request->customers_notifications_type == 'some'){
                $request['customers_notifications_customers'] = implode(',',$request->customers_notifications_customers) ;
            }
            $request['admins_id'] = auth()->user()->admins_id ;

            $message =  CustomerNotification::create($request->all()) ;
  
            foreach($customers as $customer){
                $type = 'message';
                $data['ar'] = $message->customers_notifications_text_ar ;
                $data['en'] = $message->customers_notifications_text_en ;
                $data['data'] = $message ;
                $data['created_at'] =  Carbon::now()->format('h:i:s yy-m-d');
                $customer->notify(new Notifications($data,null,$type));
                $this->sendNotification($customer,$message );
            }
            return redirect()->route('admin.customers_notifications.index')->with('status', __('general::lang.sendSuccessfully'));
        }else{
            return back()->withErrors(__('main::lang.notFoundcustomers'));
        }

    }

    public function sendNotification($customer, $data)
    {
        $token = $customer->device_token ;
        $locale = $customer->customers_locale ;
        if($locale == 'ar'){
            $subject = $data->customers_notifications_title_ar;
            $text = $data->customers_notifications_text_ar;
        }else{
            $subject = $data->customers_notifications_title_en;
            $text = $data->customers_notifications_text_en;
        }
        if( $token){
            $notification = new SendNotification();
            $notification->setToken($token)
                ->setData(array('click_action' =>  'FLUTTER_NOTIFICATION_CLICK','type'=>'message','data'=>$data))
                ->setSubject($subject)
                ->setText($text)
                ->setImage($data->image_url)
                ->setClickAction($data->customers_notifications_action_value)
                ->sendToAndroid();
        }
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function show(Request $request,$id)
    {
        $customer_notification = CustomerNotification::findOrFail($id);
        // dd($customer_notification);
        return view('main::admin.customers_notifications.show', compact('customer_notification'));
    }


    /**
     * Show the form for editing the specified resource.
     *
     * @param  \Modules\General\Models\Admin  $admin
     * @return \Illuminate\Http\Response
     */
    public function edit(Request $request, CustomerNotification $customer_notification)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(CustomerNotificationRequest $request, CustomerNotification $customer_notification)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(CustomerNotification $customer_notification)
    {
        // $customer_notification->delete();
        // return back()->with('status', __('main::lang.customerDeleted'));
    }

}
