<?php
namespace Modules\Main\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Http\Request;
use Modules\General\Models\Language;

class CustomerNotificationRequest extends FormRequest
{
	
	/**
	 * Get the validation rules that apply to the request.
	 *
	 * @return array
	 */
	public function rules(Request $request)
	{
		$rules = [
			'customers_notifications_pattern'		=> 'required',
			'customers_notifications_type' 			=> 'required',
			'customers_notifications_action' 		=> 'required',
			'customers_notifications_text_ar' 		=> 'required',
			'customers_notifications_text_en' 		=> 'required',
			'customers_notifications_title_ar' 		=> 'required',
			'customers_notifications_title_en' 		=> 'required',
		];
		if($request->customers_notifications_type == 'some'){
			$rules['customers_notifications_customers'] = 'required|array' ;
		}
		if($request->customers_notifications_type == 'country'){
			$rules['countries_id'] = 'required' ;
		}
		if($request->customers_notifications_type == 'gender'){
			$rules['customers_gender'] = 'required' ;
		}
		if($request->customers_notifications_action == 'url'){
			$rules['customers_notifications_action_value'] = 'required' ;
		}
		if($request->customers_notifications_action == 'deep_link'){
			$rules['stores_id'] = 'required' ;
		}
	 
		$languages = Language::active()->get();
        foreach ($languages as $language) {
        	//
        }
        if ($this->isMethod('PUT')) {
            //
        }


		return $rules;
	}

	/**
	 * Get the validation messages that apply to the request.
	 *
	 * @return array
	 */
	public function messages()
	{
		return [];
	}

	/**
	 * Determine if the user is authorized to make this request.
	 *
	 * @return bool
	 */
	public function authorize()
	{
		return true;
	}
}
