<?php
namespace Modules\Main\Imports;

use Modules\Main\Models\Store;
use Modules\Main\Models\StoreTranslation;
use Modules\Main\Models\Offer;
use Modules\Main\Models\Category;
use Modules\Main\Models\Country;
use Modules\General\Models\Language;

use Maatwebsite\Excel\Concerns\ToModel;
use Illuminate\Support\Collection;
use Illuminate\Support\Facades\Validator;
use Maatwebsite\Excel\Concerns\ToCollection;
use Maatwebsite\Excel\Concerns\WithChunkReading;
use Maatwebsite\Excel\Concerns\WithHeadingRow;
use Maatwebsite\Excel\Concerns\WithBatchInserts;
use Maatwebsite\Excel\Concerns\WithMappedCells	;
// use Maatwebsite\Excel\Concerns\SkipsOnFailure;
class StoresImport implements ToCollection ,WithHeadingRow, WithChunkReading
{
    public function collection(Collection $rows)
    {
        Validator::make($rows->toArray(), [
            '*.stores_code'       => 'required|exists:mysql.stores,stores_code',
            '*.stores_logo'       => 'required',
            '*.stores_link'       => 'required',
            '*.stores_is_special' => 'required|in:0,1',
            '*.stores_position'   => 'required',
            '*.stores_status'     => 'required|in:0,1',
            '*.stores_name_ar'    => 'required',
            '*.stores_name_en'    => 'required',
            // '*.stores_desc_ar' => 'required',
            // '*.stores_desc_en' => 'required',

        ],['*.stores_code.regex'=>__('validation.SpaceNotAllowedForCode')])->validate();

        // dd($rows) ;
        foreach($rows as $row) {
       
             $store = Store::where('stores_code',$row['stores_code'])->first();
             if(!$store){
                $store = new Store ;
             }
            $store->stores_code             = $row['stores_code'] ;
            $store->stores_logo             = $row['stores_logo'] ;
            $store->stores_link             = $row['stores_link'] ;
            $store->stores_is_special       = (string)$row['stores_is_special'] ;
            $store->stores_position         = $row['stores_position'] ;
            $store->stores_status           = (string)$row['stores_status'] ;
            $store->save() ;

            if(isset($row['categories_codes']) && is_array(explode(',',$row['categories_codes'])) ){
                $categories_codes =[];
                foreach(explode(',',$row['categories_codes']) as $value){
                    $categories_codes[] = trim($value);
                }
                $categories_ids   = Category::whereIn('categories_code',$categories_codes)->get()->pluck('categories_id');
                $store->categories()->sync($categories_ids);
            }

            if(isset($row['countries_codes']) && is_array(explode(',',$row['countries_codes'])) ){
                $countries_codes =[];
                foreach(explode(',',$row['countries_codes']) as $value){
                    $countries_codes[] = trim($value);
                }
                $countries_ids   = Country::whereIn('countries_code',$countries_codes)->orWhereIn('countries_id',$countries_codes)->get()->pluck('countries_id');
                $store->countries()->sync($countries_ids);
            }
            
            $langs = Language::active()->get();
            foreach($langs as $lang){
                if(isset($row['stores_name_'.$lang->locale])){
                    $storeTranslation = StoreTranslation::where('stores_id',$store->stores_id)->where('locale',$lang->locale)->first();
                    if(!$storeTranslation){
                        $storeTranslation      = new StoreTranslation ;
                    }
                    $storeTranslation->stores_id          = $store->stores_id;
                    $storeTranslation->locale             = $lang->locale;
                    $storeTranslation->stores_name        = $row['stores_name_'.$lang->locale] ;
                    $storeTranslation->stores_desc        = isset($row['stores_desc_'.$lang->locale]) ? $row['stores_desc_'.$lang->locale] : '';
                    $storeTranslation->save() ;
                }
            }
           
            
        }

    }
    public function batchSize(): int
    {
        return 1000;
    }
    public function onFailure(Failure ...$failures)
    {
        // Handle the failures how you'd like.
    }
    public function chunkSize(): int
    {
        return 1000;
    }
 
}
