<?php

namespace Modules\Main\Models;

use Illuminate\Database\Eloquent\Model;
use Modules\General\Models\StorageHandle;

class Currency extends Model
{
    use \Astrotomic\Translatable\Translatable, StorageHandle;
    protected $connection = 'mysql';
    /**
     * Table name.
     *
     * @var string
     */
    protected $table = 'currencies';

    /**
     * Primary key.
     *
     * @var string
     */
    protected $primaryKey = 'currencies_id';
    protected $translationForeignKey = 'currencies_id';

    /**
     * Translated attributes.
     *
     * @var array
     */
    public $translatedAttributes =  [
        'currencies_name'
    ];

    /**
     * Timestamps.
     *
     * @var string
     */
    const CREATED_AT = 'currencies_created_at';
    const UPDATED_AT = 'currencies_updated_at';

    /**
     * Fillable fields.
     *
     * @var array
     */
    protected $fillable = [
       'currencies_code'
    ];

}
