<?php

namespace Modules\Main\Models;

use Illuminate\Database\Eloquent\Model;

class CurrencyTranslation extends Model
{
    /**
     * Table name.
     *
     * @var string
     */
    protected $table = 'currency_translations';
    protected $connection = 'mysql';
    /**
     * Primary key.
     *
     * @var string
     */
    protected $primaryKey = 'currencies_trans_id';

    /**
     * Timestamps.
     *
     * @var boolean
     */
    public $timestamps = false;

    /**
     * Fillable fields.
     *
     * @var array
     */
    protected $fillable = [
        'currencies_name'
    ];

    /**
     * Many to one relation with currencies.
     *
     * @return collection of currency
     */
    public function currency()
    {
    	return $this->belongsTo('Modules\Main\Models\City', 'currencies_id', 'currencies_id');
    }
}
