<?php

namespace Modules\Main\Models;

use Illuminate\Database\Eloquent\Model;
use Modules\General\Models\StorageHandle;

class Sponsor extends Model
{
    use  StorageHandle;
    protected $connection = 'mysql';
    /**
     * Table name.
     *
     * @var string
     */
    protected $table = 'sponsors';

    /**
     * Primary key.
     *
     * @var string
     */
    protected $primaryKey = 'sponsors_id';
    protected $translationForeignKey = 'sponsors_id';

    /**
     * Timestamps.
     *
     * @var string
     */
    const CREATED_AT = 'sponsors_created_at';
    const UPDATED_AT = 'sponsors_updated_at';

    /**
     * Fillable fields.
     *
     * @var array
     */
    protected $fillable = [
       'sponsors_name','sponsors_url','sponsors_email','sponsors_phone','countries_id'
    ];

    public function country()
    {
        return $this->belongsTo('Modules\Main\Models\Country', 'countries_id', 'countries_id');
    }
}
