@extends('general::layouts.master')

@section('main')
  <main class="main">

  	{{-- Breadcrumb Section --}}
    <ol class="breadcrumb">
      <li class="breadcrumb-item"> <a href="{{ route('admin.dashboard.home') }}">{{ __('general::lang.home') }} </a></li>
      <li class="breadcrumb-item  active">{{ __('general::lang.settings') }}</li>
	  <li class="breadcrumb-item  active"> {{ __('main::lang.currencies') }}</li>
    </ol>
	{{-- end Breadcrumb Section --}}

    <div class="container-fluid">
      <div class="animated fadeIn">

      	{{-- Operations Messages --}}
      	@include('general::layouts.includes.messages')

        {{-- Search Section --}}
        <div class="card">
            <div class="card-body">
                <form class="form-horizontal" action="{{ route('admin.currencies.index') }}" method="get">
                <div class="row">
                    <div class="form-group col-12 col-md-2 text-center">
                        @can('create currencies')
                            <a href="{{ route('admin.currencies.create') }}" class="btn btn-success btn-md"><i class="fa fa-plus"></i></a>
                        @endcan
                    </div>

                    <div class="form-group col-12 col-md-3 text-center">
                        <input class="form-control" type="text" name="title" placeholder="{{ __('main::lang.title') }}" value="{{ old('title') }}">
                    </div>

                    <div class="form-group col-12 col-md-2">
                        <button type="submit" class="btn btn-primary btn-md"><i class="fa fa-search"></i></button>
                        <button type="button" class="btn btn-secondary btn-md search-reset"><i class="fa fa-ban"></i></button>
                    </div>
                </div>
                <!-- /.row-->
                </form>
            </div>
        </div>
      	{{-- Header Section --}}
        <div class="card d-none d-md-block">
          <div class="card-header">
          	<div class="row">
          		<div class="col-12 col-md-4 text-center"><strong>{{ __('main::lang.code') }}</strong></div>
          		<div class="col-12 col-md-4 text-center"><strong>{{ __('main::lang.name') }}</strong></div>
          		<div class="col-12 col-md-4 "><strong>{{ __('main::lang.actions') }}</strong></div>
          	</div>
          </div>
        </div>

      	{{-- Data Section --}}
            @forelse ($currencies as $currency)
            @php
                $f = true;
            @endphp
        	@foreach ($currency->translations->sortBy('locale') as $currencyTrans)
		        <div class="card {{ $loop->parent->even ? 'even-record' : '' }}">
		          <div class="card-body">
		          	<div class="row">
		          		<div class="col-xs-12 col-md-4 text-md-center">
		          			@if ($f)
                              <a href="{{ route('admin.currencies.show', [$currency->currencies_id]) }}">
			          			<div class="row mb-2 mb-md-0">
			          				<div class="col-4 d-block d-md-none"><strong>{{ __('main::lang.code') }}</strong></div>
			          				<div class="col-8 col-md-12">{{ $currency->currencies_code }}</div>
			          			</div>
                              </a>
		          			@endif
		          		</div>
		        

                        <div class="col-12 col-md-4 text-md-center">
                            <a href="{{ route('admin.currencies.show', [$currency->currencies_id]) }}">
                                <div class="row mb-2 mb-md-0">
                                    <div class="col-4 d-block d-md-none"><strong>{{ __('main::lang.name') }}</strong></div>
                                    <div class="col-8 col-md-12">{{ $currencyTrans->currencies_name }}</div>
                                </div>
                            </a>
                        </div>

		          		<div class="col-12 col-md-2">
		          			<div class="row mb-2 mb-md-0">
		          				<div class="col-4 d-block d-md-none"><strong>{{ __('main::lang.actions') }}</strong></div>
		          				<div class="col-8 col-md-12">
                                    <form method="POST" action="{{ route('admin.currencies.destroy', $currency->currencies_id) }}">
                                        @csrf
                                        @method('DELETE')
                                        @can('view currencies')
                                            <a href="{{ route('admin.currencies.show', [$currency->currencies_id, 'activeLocale' => $currencyTrans->locale]) }}"
                                                class="btn btn-primary btn-md"><i class="fa fa-eye"></i></a>
                                        @endcan
                                        @can('update currencies')
                                            <a href="{{ route('admin.currencies.edit', [$currency->currencies_id, 'activeLocale' => $currencyTrans->locale]) }}"
                                                class="btn btn-warning btn-md"><i class="fa fa-edit"></i></a>
                                        @endcan
                                        @can('delete currencies')
                                            <button type="submit" class="btn btn-danger btn-md delete-form">
                                                <i class="fa fa-trash"></i>
                                            </button>
                                        @endcan
                                    </form>

		          				</div>
		          			</div>
		          		</div>
		          	</div>
		          </div>
		        </div>
		        @php
		        	$f = false;
		        @endphp
        	@endforeach
				@empty
	        <div class="card">
	          <div class="card-body text-center text-danger">
	          	{{ __('main::lang.noData') }}
	          </div>
	        </div>
				@endforelse

				{{ $currencies->appends(request()->except('page'))->links() }}
      </div>
    </div>
  </main>
@endsection
