@extends('general::layouts.master')

@section('main')
  <main class="main">
    <!-- Breadcrumb-->
    <ol class="breadcrumb">
      <li class="breadcrumb-item">  <a href="{{ route('admin.dashboard.home') }}">{{ __('general::lang.home') }} </a></li>
      <li class="breadcrumb-item  active">{{ __('main::lang.customers') }}</li>
      <li class="breadcrumb-item">
        <a href="{{ route('admin.customers_notifications.index') }}">{{ __('main::lang.customers_notifications') }}</a>
      </li>
      <li class="breadcrumb-item  active">{{ __('main::lang.create') }}</li>
    </ol>
    <div class="container-fluid">
      <div class="animated fadeIn">
        <div class="card">
          <div class="card-header">
            <strong>{{ __('main::lang.create') }}</strong>
          </div>
          <form class="form-horizontal" action="{{ route('admin.customers_notifications.store') }}" method="post" enctype="multipart/form-data">
          	@csrf
          	@include('main::admin.customers_notifications.form')
	          <div class="card-footer">
                @can('view customers_notifications')
                    <a href="{{ route('admin.customers_notifications.index') }}" class="btn btn-secondary btn-md">
                    <i class="fa fa-arrow-left"></i>
                    </a>
                @endcan
                <button class="btn btn-success btn-md" type="submit">
                    <i class="fa fa-save"></i>
                </button>
	          </div>
          </form>
        </div>
      </div>
    </div>
  </main>
@endsection
