
@php
  $activeLocale = old('activeLocale', 'general');
  $activeLocale = 'general';
@endphp

<div class="card-body">
  @include('main::layouts.includes.messages')

  {{-- Tabs --}}
  <ul class="nav nav-tabs" id="langsTabs" role="tablist">
    <li class="nav-item">
      <a class="nav-link {{ $activeLocale == 'general' ? 'active' : '' }}" id="general-tab" data-toggle="tab" href="#general" role="tab" aria-controls="general" aria-selected="true">
      {{ __('main::lang.general') }}</a>
    </li>
    @foreach ($langs as $lang)
      <li class="nav-item">
        <a class="nav-link {{ $activeLocale == $lang->locale ? 'active' : '' }}" id="{{ $lang->locale }}-tab" data-toggle="tab" href="#{{ $lang->locale }}"
          role="tab" aria-controls="{{ $lang->locale }}" aria-selected="false">
          {{ __('main::lang.'. $lang->locale) }}
        </a>
      </li>
    @endforeach
  </ul>

  {{-- Tabs Content --}}
  <div class="tab-content" id="langsTabsContent">
    <div class="tab-pane fade {{ $activeLocale == 'general' ? 'show active' : '' }}" id="general" role="tabpanel" aria-labelledby="general-tab">
      <div class="row">
        <div class="col-lg-9">

            <div class="form-group row">
              <label class="col-md-2 col-form-label" for="customers_notifications_pattern">{{ __('main::lang.pattern') }}<span class="text-danger"> *</span></label>
              <div class="col-md-10">
                <select name="customers_notifications_pattern" id="customers_notifications_pattern" class="form-control select2 {{ $errors->first('customers_notifications_pattern') ? 'is-invalid' : '' }}" placeholder="{{ __('main::lang.pattern') }}">
                  <option value="push" selected>{{__('main::lang.push')}}</option>
                  <option value="in_app">{{__('main::lang.in_app')}}</option>
                </select>
                @if ($errors->first('customers_notifications_pattern'))
                    <div class="invalid-feedback">{{ $errors->first('customers_notifications_pattern') }}</div>
                @endif
              </div>
            </div>

            <div class="form-group row">
              <label class="col-md-2 col-form-label" for="customers_notifications_action">{{ __('main::lang.action_type') }}<span class="text-danger"> *</span></label>
              <div class="col-md-10">
                <select name="customers_notifications_action" id="customers_notifications_action" class="form-control select2 {{ $errors->first('customers_notifications_action') ? 'is-invalid' : '' }}" placeholder="{{ __('main::lang.action_type') }}">
                  <option value="url" selected>{{__('main::lang.url')}}</option>
                  <option value="deep_link">{{__('main::lang.deep_link')}}</option>
                </select>
                @if ($errors->first('customers_notifications_action'))
                    <div class="invalid-feedback">{{ $errors->first('customers_notifications_action') }}</div>
                @endif
              </div>
            </div>

            <div class="form-group row" id="action_url">
              <label class="col-md-2 col-form-label" for="customers_notifications_action_value">{{ __('main::lang.url') }}<span class="text-danger"> *</span></label>
              <div class="col-md-10">
                <input class="form-control {{ $errors->first('customers_notifications_action_value') ? 'is-invalid' : '' }}" id="customers_notifications_action_value" type="text" name="customers_notifications_action_value"
                placeholder="{{ __('main::lang.url') }}" value="{{ old('customers_notifications_action_value') }}">
                @if ($errors->first('customers_notifications_action_value'))
                    <div class="invalid-feedback">{{ $errors->first('customers_notifications_action_value') }}</div>
                @endif
              </div>
            </div>

            <div class="form-group row d-none" id="action_deep_link">
              <label class="col-md-2 col-form-label" for="stores_id">{{ __('main::lang.store') }}<span class="text-danger"> *</span></label>
              <div class="col-md-10">
                {!! Form::select('stores_id', $stores,  null, ['class' =>  $errors->first('stores_id') ? 'is-invalid form-control select2' : 'form-control select2','placeholder'=>__('main::lang.store'),'id'=>'stores_id']) !!}
                @if ($errors->first('stores_id'))
                    <div class="invalid-feedback">{{ $errors->first('stores_id') }}</div>
                @endif
              </div>
            </div>

            <div class="form-group row">
              <label class="col-md-2 col-form-label" for="customers_notifications_type">{{ __('main::lang.type') }}<span class="text-danger"> *</span></label>
              <div class="col-md-10">
                <select class="form-control select2 {{ $errors->first('customers_notifications_type') ? 'is-invalid' : '' }}" name="customers_notifications_type" id="choose_type" placeholder="{{ __('main::lang.type') }}" >
                  <option value="all" selected>{{__('main::lang.allCustomers')}}</option>
                  <option value="some">{{__('main::lang.someCustomers')}}</option>
                  <option value="country">{{__('main::lang.country')}}</option>
                  <option value="gender">{{__('main::lang.gender')}}</option>
                </select> 
                @if ($errors->first('customers_notifications_type'))
                    <div class="invalid-feedback">{{ $errors->first('customers_notifications_type') }}</div>
                @endif
              </div>
            </div>

            <div class="form-group row allCustomers  d-none">
              <label class="col-md-2 col-form-label" for="customers_notifications_customers">{{ __('main::lang.customers') }}<span class="text-danger"> *</span></label>
              <div class="col-md-10 ">
                {{ Form::select('customers_notifications_customers[]',$customers,old('customers_notifications_customers'),["class"=>"form-control js-states","multiple"=>"multiple","id"=>"customers_notifications_customers" ]) }}
                @if ($errors->first('customers_notifications_customers'))
                    <div class="invalid-feedback">{{ $errors->first('customers_notifications_customers') }}</div>
                @endif
              </div>
            </div>

            <div class="form-group row countries_div  d-none">
              <label class="col-md-2 col-form-label" for="countries_id">{{ __('main::lang.country') }}<span class="text-danger"> *</span></label>
              <div class="col-md-10 ">
                {{ Form::select('countries_id',$countries,old('countries_id'),["class"=>"form-control js-states","id"=>"countries_id",'placeholder'=>__('main::lang.country') ]) }}
                @if ($errors->first('countries_id'))
                    <div class="invalid-feedback">{{ $errors->first('countries_id') }}</div>
                @endif
              </div>
            </div>

            <div class="form-group row gender_div  d-none">
              <label class="col-md-2 col-form-label" for="customers_gender">{{ __('main::lang.gender') }}<span class="text-danger"> *</span></label>
              <div class="col-md-10 ">
                {{ Form::select('customers_gender',['male'=>__('main::lang.male'),'female'=>__('main::lang.female')],old('customers_gender'),["class"=>"form-control js-states","id"=>"customers_gender",'placeholder'=>__('main::lang.gender') ]) }}
                @if ($errors->first('customers_gender'))
                    <div class="invalid-feedback">{{ $errors->first('customers_gender') }}</div>
                @endif
              </div>
            </div>
 
            <div class="form-group row ">
              <label class="col-md-2 col-form-label" for="customers_notifications_image">{{ __('main::lang.img') }}<span class="text-danger">  </span></label>
              <div class="col-md-10">
                @include('main::layouts.includes.imagePreview', ['name' => 'customers_notifications_image', 'value' => null,'type'=>'notifications'])
                @if ($errors->first('customers_notifications_image'))
                  <div class="invalid-feedback">{{ $errors->first('customers_notifications_image') }}</div>
                @endif
              </div>
            </div>

 
        </div>
      </div>
    </div>


    {{-- Languages Tabs --}}
    @foreach ($langs as $lang)
      <div class="tab-pane fade {{ $activeLocale == $lang->locale ? 'show active' : '' }}" id="{{ $lang->locale }}" role="tabpanel" aria-labelledby="{{ $lang->locale }}-tab">

        <div class="row">

          <div class="col-lg-9">
            <p class="text-primary h6">{{ __('main::lang.currencyDetails') }}</p>
            <div class="form-group row">
              <label class="col-md-2 col-form-label">{{ __('main::lang.title') }}<span class="text-danger"> *</span></label>

              <div class="col-md-10">
                <input class="form-control character-title {{ $errors->first('customers_notifications_title_'.$lang->locale) ? 'is-invalid' : '' }}" type="text"
                 name="{{ 'customers_notifications_title_'.$lang->locale }}" placeholder="{{ __('main::lang.title') }}"
                 value="{{ old('customers_notifications_title_'.$lang->locale) }}">
                @if ($errors->first('customers_notifications_title_'.$lang->locale))
                  <div class="invalid-feedback">{{ $errors->first('customers_notifications_title_'.$lang->locale) }}</div>
                @endif
              </div>
              <span class="character-count">{{__('main::lang.remainingChar')}} : 35</span>
            </div>

            <div class="form-group row">
              <label class="col-md-2 col-form-label">{{ __('main::lang.text') }}<span class="text-danger"> *</span></label>

              <div class="col-md-10">
                <input class="form-control character-desc  {{ $errors->first('customers_notifications_text_'.$lang->locale) ? 'is-invalid' : '' }}" type="text"
                 name="{{ 'customers_notifications_text_'.$lang->locale }}" placeholder="{{ __('main::lang.text') }}"
                 value="{{ old('customers_notifications_text_'.$lang->locale) }}">
                @if ($errors->first('customers_notifications_text_'.$lang->locale))
                  <div class="invalid-feedback">{{ $errors->first('customers_notifications_text_'.$lang->locale) }}</div>
                @endif
              </div>
              <span class="character-count">{{__('main::lang.remainingChar')}} : 70</span>
            </div>

          </div>

        </div>


      </div>
    @endforeach


  </div>
</div>
@section('script')
<script>
	$('#choose_type').change(function() {
		value = $('#choose_type').val() ;
    $('.allCustomers').addClass('d-none');
    $('.countries_div').addClass('d-none');
    $('.gender_div').addClass('d-none');
		if(value == 'some'){
			$('.allCustomers').removeClass('d-none');
		}else if(value == 'country'){
			$('.countries_div').removeClass('d-none');
		}else if(value == 'gender'){
			$('.gender_div').removeClass('d-none');
		}
	})

	$('#customers_notifications_action').change(function() {
		action = $('#customers_notifications_action').val() ;
		if(action == 'url'){
			$('#action_url').removeClass('d-none');
			$('#action_deep_link').addClass('d-none');

		}else{
			$('#action_deep_link').removeClass('d-none');
			$('#action_url').addClass('d-none');
		}
	})

  $("#customers_notifications_customers").select2({
      placeholder: "Select a customers"
  });


  $('.character-title').on('keydown keyup', function(e){
      var total = 35;
      var value = $(this).val();
      var remaining = total - value.length;
      if(remaining == 0 && e.keyCode != 46 && e.keyCode != 8)  // 46 => delete, 8 => backspace
      {
          e.preventDefault();
      }
      $(this).parent('.col-md-10').siblings('.character-count').text("{{__('main::lang.remainingChar')}} : "+remaining);

  });
  $('.character-desc').on('keydown keyup', function(e){
      var total = 70;
      var value = $(this).val();
      var remaining = total - value.length;
      if(remaining == 0 && e.keyCode != 46 && e.keyCode != 8)  // 46 => delete, 8 => backspace
      {
          e.preventDefault();
      }
      $(this).parent('.col-md-10').siblings('.character-count').text("{{__('main::lang.remainingChar')}} : "+remaining);

  });
</script>
@endsection