@extends('general::layouts.master')

@section('main')
  <main class="main">
  	{{-- Breadcrumb Section --}}
    <ol class="breadcrumb">
      <li class="breadcrumb-item">{{ __('main::lang.home') }}</li>
      <li class="breadcrumb-item  active">{{ __('main::lang.sponsors') }}</li>

    </ol>
    <div class="container-fluid">
      <div class="animated fadeIn">
      	@include('general::layouts.includes.messages')

      	{{-- Search Section --}}
        <div class="card">
          <div class="card-body">
            <form class="form-horizontal" action="{{ route('admin.sponsors.index') }}" method="get">

              <div class="row">
             
                <div class="form-group col-12 col-md-3 text-center">
                  <input class="form-control" type="name" name="name" placeholder="{{ __('main::lang.name') }}" value="{{ old('name') }}">
                </div>
				<div class="form-group col-12 col-md-3 text-center">
					<input class="form-control" type="email" name="email" placeholder="{{ __('main::lang.email') }}" value="{{ old('email') }}">
				</div>
				<div class="form-group col-12 col-md-2 text-center">
					<input class="form-control" type="phone" name="phonr" placeholder="{{ __('main::lang.phone') }}" value="{{ old('phone') }}">
				</div>

                <div class="form-group col-12 col-md-2 text-center">
					{!! Form::select('country', $countries, null, ['class' =>'form-control','placeholder'=>__('main::lang.country'),'id'=>'country']) !!}
                </div>

                <div class="form-group col-12 col-md-2  ">
                	<button type="submit" class="btn btn-primary btn-sm"><i class="fa fa-search"></i></button>
                	<button type="button" class="btn btn-secondary btn-sm search-reset"><i class="fa fa-ban"></i></button>
                </div>
              </div>
              <!-- /.row-->
            </form>
          </div>
        </div>

      	{{-- Header Section --}}
        <div class="card d-none d-md-block">
          <div class="card-header">
          	<div class="row">
          		<div class="col-12 col-md-2 text-center"><strong>{{ __('main::lang.name') }}</strong></div>
          		<div class="col-12 col-md-2 text-center"><strong>{{ __('main::lang.email') }}</strong></div>
          		<div class="col-12 col-md-2 text-center"><strong>{{ __('main::lang.phone') }}</strong></div>
          		<div class="col-12 col-md-2 text-center"><strong>{{ __('main::lang.url') }}</strong></div>
          		<div class="col-12 col-md-2 text-center"><strong>{{ __('main::lang.country') }}</strong></div>
           		<div class="col-12 col-md-2 text-center"><strong>{{ __('main::lang.date') }}</strong></div>
          	</div>
          </div>
        </div>

      	{{-- Data Section --}}
		@forelse ($sponsors as $sponsor)
	        <div class="card">
	          <div class="card-body">
	          	<div class="row">

	          		<div class="col-12 col-md-2 text-md-center">
	          			<div class="row mb-2 mb-md-0">
	          				<div class="col-4 d-block d-md-none"><strong>{{ __('main::lang.name') }}</strong></div>
	          				<div class="col-8 col-md-12">{{ $sponsor->sponsors_name}}</div>
	          			</div>
	          		</div>

					<div class="col-12 col-md-2 text-md-center">
						<div class="row mb-2 mb-md-0">
							<div class="col-4 d-block d-md-none"><strong>{{ __('main::lang.email') }}</strong></div>
							<div class="col-8 col-md-12">{{ $sponsor->sponsors_email }}</div>
						</div>
					</div>

					<div class="col-12 col-md-2 text-md-center">
						<div class="row mb-2 mb-md-0">
							<div class="col-4 d-block d-md-none"><strong>{{ __('main::lang.phone') }}</strong></div>
							<div class="col-8 col-md-12">{{ $sponsor->sponsors_phone }}</div>
						</div>
					</div>

					<div class="col-12 col-md-2 text-md-center">
						<div class="row mb-2 mb-md-0">
							<div class="col-4 d-block d-md-none"><strong>{{ __('main::lang.url') }}</strong></div>
							<div class="col-8 col-md-12">{{ $sponsor->sponsors_url }}</div>
						</div>
					</div>

                    <div class="col-12 col-md-2 text-md-center">
                        <div class="row mb-2 mb-md-0">
                            <div class="col-4 d-block d-md-none"><strong>{{ __('general::lang.country') }}</strong></div>
                            <div class="col-8 col-md-12">{{ $sponsor->country ? $sponsor->country->countries_name : '' }}</div>
                        </div>
                    </div>

	          		<div class="col-12 col-md-2 text-md-center">
	          			<div class="row mb-2 mb-md-0">
	          				<div class="col-4 d-block d-md-none"><strong>{{ __('main::lang.date') }}</strong></div>
	          				<div class="col-8 col-md-12">
	          					{{$sponsor->sponsors_created_at->format('Y-m-d')}}
	          				</div>
	          			</div>
	          		</div>

	          	</div>
	          </div>
	        </div>
		@empty
	        <div class="card">
	          <div class="card-body text-center text-danger">
	          	{{ __('main::lang.noData') }}
	          </div>
	        </div>
		@endforelse

		{{ $sponsors->appends(request()->query())->links() }}

      </div>
    </div>
  </main>
@endsection


@section('script')
<script>
	$('#choose_type').change(function() {
		value = $('#choose_type').val() ;
		if(value == 'some'){
			$('.allCustomers').removeClass('d-none');
		}else{
			$('.allCustomers').addClass('d-none');
		}
	})

	$('#sponsors_action').change(function() {
		action = $('#sponsors_action').val() ;
		if(action == 'url'){
			$('#action_url').removeClass('d-none');
			$('#action_deep_link').addClass('d-none');

		}else{
			$('#action_deep_link').removeClass('d-none');
			$('#action_url').addClass('d-none');
		}
	})

    $("#sponsors_customers").select2({
        placeholder: "Select a state"
    });
</script>
@endsection
