@extends('general::layouts.master')

@section('main')
  <main class="main">
    <!-- Breadcrumb-->
    <ol class="breadcrumb">
      <li class="breadcrumb-item">{{ __('main::lang.home') }}</li>
      <li class="breadcrumb-item">
        <a href="{{ route('admin.sponsors.index') }}">{{ __('main::lang.sponsors') }}</a>
      </li>
      <li class="breadcrumb-item  active">{{ __('main::lang.show') }}</li>
    </ol>
    <div class="container-fluid">
      <div class="animated fadeIn">
        <div class="card">
          <div class="card-header">
            <i class="fa fa-align-justify"></i> {{ __('main::lang.show') }}
          </div>
          <div class="card-body">
            <ul class="list-group">
              <li class="list-group-item">
                <div class="row">
                  <div class="col-12 col-md-2"><strong>{{ __('main::lang.message') }}</strong></div>
                  <div class="col-12 col-md-10">{{ $customer_notification->sponsors_text }}</div>
                </div>
              </li>
              <li class="list-group-item">
                <div class="row">
                  <div class="col-12 col-md-2"><strong>{{ __('general::lang.admin') }}</strong></div>
                  <div class="col-12 col-md-10">{{ $customer_notification->admin ? $customer_notification->admin->name : '' }}</div>
                </div>
              </li>
              <li class="list-group-item">
                <div class="row">
                  <div class="col-12 col-md-2"><strong>{{ __('main::lang.type') }}</strong></div>
                  <div class="col-12 col-md-10">
                    @if ($customer_notification->sponsors_type == 'all')
                      <span class="badge badge-success">{{ __('main::lang.allCustomers') }}</span>
                    @else
                      <span class="badge badge-secondary">{{ __('main::lang.someCustomers') }}</span>
                    @endif
                  </div>
                </div>
              </li>

              <li class="list-group-item">
                <div class="row">
                  <div class="col-12 col-md-2"><strong>{{ __('main::lang.action_type') }}</strong></div>
                  <div class="col-12 col-md-10">
                    @if ($customer_notification->sponsors_action == 'url')
                      <span class="badge badge-success">{{ __('main::lang.url') }}</span>
                    @else
                      <span class="badge badge-secondary">{{ __('main::lang.deep_link') }}</span>
                    @endif
                  </div>
                </div>
              </li>

              <li class="list-group-item">
                <div class="row">
                  <div class="col-12 col-md-2"><strong>{{ __('main::lang.url') }}</strong></div>
                  <div class="col-12 col-md-10">
                    @if ($customer_notification->sponsors_action == 'url')
                      {{$customer_notification->sponsors_action_value}}
                    @else
                      {{$customer_notification->store ? $customer_notification->store->stores_name : ''}}
                    @endif
                  </div>
                </div>
              </li>

              
              <li class="list-group-item">
                <div class="row">
                  <div class="col-12 col-md-2"><strong>{{ __('main::lang.date') }}</strong></div>
                  <div class="col-12 col-md-10">{{ $customer_notification->sponsors_created_at->format('Y-m-d') }}</div>
                </div>
              </li>
              <li class="list-group-item {{$customer_notification->sponsors_type == 'all' ? 'd-none' : ''}}">
                <div class="row">
                  <div class="col-12 col-md-2"><strong>{{ __('main::lang.customers') }}</strong></div>
                  <div class="col-12 col-md-10">
                    @foreach($customer_notification->customers as $customer)
                    <a href="{{route('admin.customers.show',$customer->customers_id)}}"> <span class="badge badge-success"> {{$customer->customers_name}} </span> </a>
                    @endforeach
                  </div>
                </div>
              </li>
            </ul>
          </div>
          <div class="card-footer">
            @can('admin.sponsors.index')
              <a href="{{ route('admin.sponsors.index') }}" class="btn btn-sm btn-secondary">
                <i class="fa fa-arrow-left"></i>
              </a>
            @endcan

          </div>
        </div>
      </div>
    </div>
  </main>
@endsection
