
<?php
  $activeLocale = old('activeLocale', 'general');
  $activeLocale = 'general';
?>

<div class="card-body">
  <?php echo $__env->make('main::layouts.includes.messages', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

  
  <ul class="nav nav-tabs" id="langsTabs" role="tablist">
    <li class="nav-item">
      <a class="nav-link <?php echo e($activeLocale == 'general' ? 'active' : ''); ?>" id="general-tab" data-toggle="tab" href="#general" role="tab" aria-controls="general" aria-selected="true">
      <?php echo e(__('main::lang.general')); ?></a>
    </li>
    <?php $__currentLoopData = $langs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lang): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
      <li class="nav-item">
        <a class="nav-link <?php echo e($activeLocale == $lang->locale ? 'active' : ''); ?>" id="<?php echo e($lang->locale); ?>-tab" data-toggle="tab" href="#<?php echo e($lang->locale); ?>"
          role="tab" aria-controls="<?php echo e($lang->locale); ?>" aria-selected="false">
          <?php echo e(__('main::lang.'. $lang->locale)); ?>

        </a>
      </li>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
  </ul>

  
  <div class="tab-content" id="langsTabsContent">
    <div class="tab-pane fade <?php echo e($activeLocale == 'general' ? 'show active' : ''); ?>" id="general" role="tabpanel" aria-labelledby="general-tab">
      <div class="row">
        <div class="col-lg-9">
            
            <div class="form-group row ">
              <label class="col-md-2 col-form-label" for="offers_image"><?php echo e(__('main::lang.img')); ?><span class="text-danger">  </span></label>
              <div class="col-md-10">
                <?php echo $__env->make('main::layouts.includes.imagePreview', ['name' => 'offers_image', 'value' => isset($offer) ? $offer->offers_image : null,'type'=>'offers'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <?php if($errors->first('offers_image')): ?>
                  <div class="invalid-feedback"><?php echo e($errors->first('offers_image')); ?></div>
                <?php endif; ?>
              </div>
            </div>

            <div class="form-group row">
                <label class="col-md-2 col-form-label" for="offers_position"><?php echo e(__('main::lang.position')); ?><span class="text-danger"> *</span></label>
                <div class="col-md-3">
                <input class="form-control <?php echo e($errors->first('offers_position') ? 'is-invalid' : ''); ?>" id="offers_position" type="text" name="offers_position"
                placeholder="<?php echo e(__('main::lang.position')); ?>" value="<?php echo e(old('offers_position', isset($offer) ? $offer->offers_position : 1)); ?>">
                <?php if($errors->first('offers_position')): ?>
                    <div class="invalid-feedback"><?php echo e($errors->first('offers_position')); ?></div>
                <?php endif; ?>
                </div>
            </div>

            <div class="form-group row">
                <label class="col-md-2 col-form-label"><?php echo e(__('main::lang.status')); ?><span class="text-danger"> *</span></label>
                <div class="col-md-6 col-form-label">
                    <?php
                    $status = old('offers_status', isset($offer) ? $offer->offers_status : 1);
                    ?>

                    <input type="hidden" id="offers_status_input" name="offers_status" value="<?php echo e($status); ?>">
                    <input type="checkbox" name="offers_statuss" id="offers_status"  <?php echo e($status ? 'checked' : ''); ?>  data-on=" <?php echo e(__('general::lang.active')); ?>" data-off=" <?php echo e(__('general::lang.stopped')); ?>" data-toggle="toggle" data-onstyle="success" data-offstyle="danger" data-width="80px" onChange="changeStatusInput('offers')">

                <?php if($errors->first('offers_status')): ?>
                    <div class="invalid-feedback"><?php echo e($errors->first('offers_status')); ?></div>
                <?php endif; ?>
                </div>
            </div>


        </div>
      </div>
    </div>


    
    <?php $__currentLoopData = $langs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lang): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
      <div class="tab-pane fade <?php echo e($activeLocale == $lang->locale ? 'show active' : ''); ?>" id="<?php echo e($lang->locale); ?>" role="tabpanel" aria-labelledby="<?php echo e($lang->locale); ?>-tab">

        <div class="row">

          <div class="col-lg-9">
            <p class="text-primary h6"><?php echo e(__('main::lang.offerDetails')); ?></p>
            <div class="form-group row">
              <label class="col-md-2 col-form-label"><?php echo e(__('main::lang.offers_name')); ?><span class="text-danger"> *</span></label>

              <div class="col-md-6">
                <input class="form-control <?php echo e($errors->first($lang->locale .'.offers_name') ? 'is-invalid' : ''); ?>" type="text"
                 name="<?php echo e($lang->locale .'[offers_name]'); ?>" placeholder="<?php echo e(__('main::lang.offers_name')); ?>"
                 value="<?php echo e(old($lang->locale .'.offers_name', isset($offer) && $offer->translate($lang->locale)  ? $offer->translate($lang->locale)->offers_name : '')); ?>">
                <?php if($errors->first($lang->locale .'.offers_name')): ?>
                  <div class="invalid-feedback"><?php echo e($errors->first($lang->locale .'.offers_name')); ?></div>
                <?php endif; ?>
              </div>
            </div>
         
            <div class="form-group row">
                <label class="col-md-2 col-form-label"><?php echo e(__('main::lang.offers_desc')); ?><span class="text-danger"> *</span></label>

                <div class="col-md-10">
                  <textarea id="<?php echo e($lang->locale); ?>-ckeditor" class="ckeditor form-control <?php echo e($errors->first($lang->locale .'.offers_desc') ? 'is-invalid' : ''); ?>" type="text" rows="5" name="<?php echo e($lang->locale .'[offers_desc]'); ?>" placeholder="<?php echo e(__('main::lang.offers_desc')); ?>"><?php echo e(old($lang->locale .'.offers_desc', isset($offer) && $offer->translate($lang->locale)  ? $offer->translate($lang->locale)->offers_desc : '')); ?></textarea>
                  <?php if($errors->first($lang->locale .'.offers_desc')): ?>
                    <div class="invalid-feedback"><?php echo e($errors->first($lang->locale .'.offers_desc')); ?></div>
                  <?php endif; ?>
                </div>
            </div>

          </div>

        </div>



      </div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>


  </div>
</div>
<?php /**PATH /home/vivacoupon/public_html/system.vivacoupon.com/system/Modules/Main/Resources/views/admin/offers/form.blade.php ENDPATH**/ ?>