<?php $__env->startSection('main'); ?>
  <main class="main">
    <!-- Breadcrumb-->
    <ol class="breadcrumb">
      <li class="breadcrumb-item"><a href="<?php echo e(route('admin.dashboard.home')); ?>"><?php echo e(__('general::lang.home')); ?> </a></li>
      <li class="breadcrumb-item">
        <a href="<?php echo e(route('admin.stores.index')); ?>"><?php echo e(__('main::lang.stores')); ?></a>
      </li>
      <li class="breadcrumb-item  active"><?php echo e(__('main::lang.show')); ?></li>
    </ol>
    <div class="container-fluid">
      <div class="animated fadeIn">
        <div class="card">
          <div class="card-header">
            <i class="fa fa-align-justify"></i> <?php echo e(__('main::lang.show')); ?>

          </div>
          <div class="card-body">

            <ul class="list-group">

              <li class="list-group-item">
                <div class="row">
                  <div class="col-12 col-md-2"><strong><?php echo e(__('main::lang.id')); ?></strong></div>
                  <div class="col-12 col-md-10"><?php echo e($store->stores_id); ?></div>
                </div>
              </li>
              <li class="list-group-item">
                <div class="row">
                  <div class="col-12 col-md-2"><strong><?php echo e(__('main::lang.stores_code')); ?></strong></div>
                  <div class="col-12 col-md-10"><?php echo e($store->stores_code); ?></div>
                </div>
              </li>
              <li class="list-group-item">
                <div class="row">
                  <div class="col-12 col-md-2"><strong><?php echo e(__('main::lang.stores_name')); ?></strong></div>
                  <div class="col-12 col-md-10"><?php echo e($store->translate(old('activeLocale', $locale))->stores_name); ?></div>
                </div>
              </li>
              
              <li class="list-group-item">
                <div class="row">
                  <div class="col-12 col-md-2"><strong><?php echo e(__('main::lang.stores_logo')); ?></strong></div>
                  <div class="col-12 col-md-10">
                    <img src="<?php echo e($store->stores_logo ? asset($store->images_url($store->stores_logo, 'medium','stores')) : asset('assets/adminPanel/img/no-image.png')); ?>" class="img-fluid img-thumbnail"  />  
                  </div>
                </div>
              </li>

              <li class="list-group-item">
                <div class="row">
                  <div class="col-12 col-md-2"><strong><?php echo e(__('main::lang.stores_link')); ?></strong></div>
                  <div class="col-12 col-md-10">
                    <a href="<?php echo e($store->stores_link); ?>" target="_blank"><?php echo e($store->stores_link); ?></a>
                  </div>
                </div>
              </li>

              <li class="list-group-item">
                <div class="row">
                  <div class="col-12 col-md-2"><strong><?php echo e(__('main::lang.categories')); ?></strong></div>
                  <div class="col-12 col-md-10">
                    <?php $__currentLoopData = $store->categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <span class="badge badge-info"> <?php echo e($category->categories_name); ?> </span>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                  </div>
                </div>
              </li>
              <li class="list-group-item">
                <div class="row">
                  <div class="col-12 col-md-2"><strong><?php echo e(__('main::lang.countries')); ?></strong></div>
                  <div class="col-12 col-md-10">
                    <?php $__currentLoopData = $store->countries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $country): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <span class="badge badge-info"> <?php echo e($country->countries_name); ?> </span>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                  </div>
                </div>
              </li>

              <li class="list-group-item">
                <div class="row">
                  <div class="col-12 col-md-2"><strong><?php echo e(__('main::lang.stores_desc')); ?></strong></div>
                  <div class="col-12 col-md-10"><?php echo $store->translate(old('activeLocale', $locale))->stores_desc; ?></div>
                </div>
              </li>

              <li class="list-group-item">
                <div class="row">
                  <div class="col-12 col-md-2"><strong><?php echo e(__('main::lang.status')); ?></strong></div>
                  <div class="col-12 col-md-10">
                    <?php echo e(__('main::lang.status_'.$store->stores_status)); ?>

                   </div>
                </div>
              </li>

              <li class="list-group-item">
                <div class="row">
                  <div class="col-12 col-md-2"><strong><?php echo e(__('main::lang.is_special')); ?></strong></div>
                  <div class="col-12 col-md-10">
                    <?php if($store->stores_is_special): ?>
                      <span class="badge badge-warning"><?php echo e(__('main::lang.special')); ?></span>
                    <?php else: ?>
                      <span class="badge badge-secondary"><?php echo e(__('main::lang.not_special')); ?></span>
                    <?php endif; ?>  
                  </div>
                </div>
              </li>

              <li class="list-group-item">
                <div class="row">
                  <div class="col-12 col-md-2"><strong><?php echo e(__('main::lang.position')); ?></strong></div>
                  <div class="col-12 col-md-10"><?php echo e($store->stores_position); ?></div>
                </div>
              </li>

            </ul>
          </div>
          <div class="card-footer">
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view stores')): ?>
              <a href="<?php echo e(route('admin.stores.index')); ?>" class="btn btn-secondary btn-md">
                <i class="fa fa-arrow-left"></i>
              </a>
            <?php endif; ?>
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('update stores')): ?>
              <a href="<?php echo e(route('admin.stores.edit', [$store->stores_id, 'activeLocale' => old('activeLocale', $locale)])); ?>" class="btn btn-warning btn-md">
                <i class="fa fa-edit"></i>
              </a>
            <?php endif; ?>
          </div>
        </div>
      </div>
    </div>
  </main>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('general::layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home2/trainopi/public_html/system-primocoupon-com/system/Modules/Main/Resources/views/admin/stores/show.blade.php ENDPATH**/ ?>