
<?php
  $activeLocale = old('activeLocale', 'general');
  $activeLocale = 'general';
?>

<div class="card-body">
  <?php echo $__env->make('main::layouts.includes.messages', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

  
  <ul class="nav nav-tabs" id="langsTabs" role="tablist">
    <li class="nav-item">
      <a class="nav-link <?php echo e($activeLocale == 'general' ? 'active' : ''); ?>" id="general-tab" data-toggle="tab" href="#general" role="tab" aria-controls="general" aria-selected="true">
      <?php echo e(__('main::lang.general')); ?></a>
    </li>
    <?php $__currentLoopData = $langs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lang): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
      <li class="nav-item">
        <a class="nav-link <?php echo e($activeLocale == $lang->locale ? 'active' : ''); ?>" id="<?php echo e($lang->locale); ?>-tab" data-toggle="tab" href="#<?php echo e($lang->locale); ?>"
          role="tab" aria-controls="<?php echo e($lang->locale); ?>" aria-selected="false">
          <?php echo e(__('main::lang.'. $lang->locale)); ?>

        </a>
      </li>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
  </ul>

  
  <div class="tab-content" id="langsTabsContent">
    <div class="tab-pane fade <?php echo e($activeLocale == 'general' ? 'show active' : ''); ?>" id="general" role="tabpanel" aria-labelledby="general-tab">
      <div class="row">
        <div class="col-lg-9">

            <div class="form-group row">
                <label class="col-md-2 col-form-label" for="currencies_code"><?php echo e(__('main::lang.code')); ?><span class="text-danger"> *</span></label>
                <div class="col-md-10">
                  <input class="form-control <?php echo e($errors->first('currencies_code') ? 'is-invalid' : ''); ?>" id="currencies_code" type="text" name="currencies_code"
                  placeholder="<?php echo e(__('main::lang.code')); ?>" value="<?php echo e(old('currencies_code', isset($currency) ? $currency->currencies_code : '')); ?>">
                  <?php if($errors->first('currencies_code')): ?>
                      <div class="invalid-feedback"><?php echo e($errors->first('currencies_code')); ?></div>
                  <?php endif; ?>
                </div>
            </div>

        </div>
      </div>
    </div>


    
    <?php $__currentLoopData = $langs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lang): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
      <div class="tab-pane fade <?php echo e($activeLocale == $lang->locale ? 'show active' : ''); ?>" id="<?php echo e($lang->locale); ?>" role="tabpanel" aria-labelledby="<?php echo e($lang->locale); ?>-tab">

        <div class="row">

          <div class="col-lg-9">
            <p class="text-primary h6"><?php echo e(__('main::lang.currencyDetails')); ?></p>
            <div class="form-group row">
              <label class="col-md-2 col-form-label"><?php echo e(__('main::lang.name')); ?><span class="text-danger"> *</span></label>

              <div class="col-md-10">
                <input class="form-control <?php echo e($errors->first($lang->locale .'.currencies_name') ? 'is-invalid' : ''); ?>" type="text"
                 name="<?php echo e($lang->locale .'[currencies_name]'); ?>" placeholder="<?php echo e(__('main::lang.name')); ?>"
                 value="<?php echo e(old($lang->locale .'.currencies_name', isset($currency) && $currency->translate($lang->locale)  ? $currency->translate($lang->locale)->currencies_name : '')); ?>">
                <?php if($errors->first($lang->locale .'.currencies_name')): ?>
                  <div class="invalid-feedback"><?php echo e($errors->first($lang->locale .'.currencies_name')); ?></div>
                <?php endif; ?>
              </div>
            </div>

          </div>

        </div>



      </div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>


  </div>
</div>
<?php /**PATH /home/vivacoupon/public_html/system.vivacoupon.com/system/Modules/Main/Resources/views/admin/currencies/form.blade.php ENDPATH**/ ?>