
<?php
  $activeLocale = old('activeLocale', 'general');
  $activeLocale = 'general';
?>
<div class="card-body">
	<?php echo $__env->make('general::layouts.includes.messages', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
  <div class="row">
    <div class="col-lg-9">
        <input type="hidden" name="advertisements_type" value="website">
         
        <ul class="nav nav-tabs" id="langsTabs" role="tablist">
          <li class="nav-item">
            <a class="nav-link <?php echo e($activeLocale == 'general' ? 'active' : ''); ?>" id="general-tab" data-toggle="tab" href="#general" role="tab" aria-controls="general" aria-selected="true">
            <?php echo e(__('general::lang.general')); ?></a>
          </li>
          <?php $__currentLoopData = $langs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lang): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <li class="nav-item">
              <a class="nav-link <?php echo e($activeLocale == $lang->locale ? 'active' : ''); ?>" id="<?php echo e($lang->locale); ?>-tab" data-toggle="tab" href="#<?php echo e($lang->locale); ?>"
                role="tab" aria-controls="<?php echo e($lang->locale); ?>" aria-selected="false">
                <?php echo e(__('general::lang.'. $lang->locale)); ?>

              </a>
            </li>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </ul>

        
        <div class="tab-content" id="langsTabsContent">
          <div class="tab-pane fade <?php echo e($activeLocale == 'general' ? 'show active' : ''); ?>" id="general" role="tabpanel" aria-labelledby="general-tab">
            <div class="row">
              <div class="col-lg-9">
                <div class="form-group row">
                  <label class="col-md-3 col-form-label" for="advertisements_name"><?php echo e(__('general::lang.name')); ?><span class="text-danger"> *</span></label>
                  <div class="col-md-9">
                    <input class="form-control <?php echo e($errors->first('advertisements_name') ? 'is-invalid' : ''); ?>" id="advertisements_name" type="text" name="advertisements_name" placeholder="<?php echo e(__('general::lang.name')); ?>"
                     value="<?php echo e(old('advertisements_name', isset($advertisement) ? $advertisement->advertisements_name : '')); ?>">
                    <?php if($errors->first('advertisements_name')): ?>
                      <div class="invalid-feedback"><?php echo e($errors->first('advertisements_name')); ?></div>
                    <?php endif; ?>
                  </div>
                </div>

                <div class="form-group row">
                  <label class="col-md-3 col-form-label" for="advertisements_view_page"><?php echo e(__('general::lang.ViewPage')); ?><span class="text-danger"> *</span></label>
                  <div class="col-md-9">
                    <?php echo Form::select('advertisements_view_page', ['home_banner'=>__('general::lang.home_banner'),'home_popup'=>__('general::lang.home_popup')],  old('advertisements_view_page', isset($advertisement) ? $advertisement->advertisements_view_page : 'home_banner') , ['class' => $errors->first('advertisements_view_page') ? 'is-invalid form-control' : 'form-control']); ?>

                    <?php if($errors->first('advertisements_view_page')): ?>`§
                      <div class="invalid-feedback"><?php echo e($errors->first('advertisements_view_page')); ?></div>
                    <?php endif; ?> 
                  </div>
                </div>

                <div class="form-group row">
                  <label class="col-md-3 col-form-label" for="advertisements_link_value"><?php echo e(__('main::lang.coupon')); ?><span class="text-danger"> </span></label>
                  <div class="col-md-9">
                    <select name="advertisements_link_value" id="advertisements_link_value" class= "<?php echo e($errors->first('advertisements_link_value') ? 'form-control is-invalid' : 'form-control'); ?>" placeholder="<?php echo e(__('main::lang.coupon')); ?>">
                      <option value=""><?php echo e(__('main::lang.coupon')); ?></option>
                      <?php $__currentLoopData = $coupons; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $coupon): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                      <option value="<?php echo e($coupon->coupons_id); ?>" <?php echo e(isset($advertisement) &&  $advertisement->advertisements_link_value == $coupon->coupons_id ? 'selected' : ''); ?>><?php echo e($coupon->coupons_name. ' ( ' . $coupon->coupons_code . ' )'); ?></option>
                      <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                  
                    <?php if($errors->first('advertisements_link_value')): ?>
                      <div class="invalid-feedback"><?php echo e($errors->first('advertisements_link_value')); ?></div>
                    <?php endif; ?>
                  </div>
                </div>

                <div class="form-group row">
                  <label class="col-md-3 col-form-label" for="advertisements_start_date"><?php echo e(__('general::lang.start_date')); ?><span class="text-danger"> </span></label>
                  <div class="col-md-9">
                    <input class="form-control <?php echo e($errors->first('advertisements_start_date') ? 'is-invalid' : ''); ?>" id="advertisements_start_date" type="date" name="advertisements_start_date" placeholder="<?php echo e(__('general::lang.start_date')); ?>"
                     value="<?php echo e(old('advertisements_start_date', isset($advertisement) ? $advertisement->advertisements_start_date : '')); ?>">
                    <?php if($errors->first('advertisements_start_date')): ?>
                      <div class="invalid-feedback"><?php echo e($errors->first('advertisements_start_date')); ?></div>
                    <?php endif; ?>
                  </div>
                </div>

                <div class="form-group row">
                  <label class="col-md-3 col-form-label" for="advertisements_end_date"><?php echo e(__('general::lang.end_date')); ?><span class="text-danger"> </span></label>
                  <div class="col-md-9">
                    <input class="form-control <?php echo e($errors->first('advertisements_end_date') ? 'is-invalid' : ''); ?>" id="advertisements_end_date" type="date" name="advertisements_end_date" placeholder="<?php echo e(__('general::lang.end_date')); ?>"
                     value="<?php echo e(old('advertisements_end_date', isset($advertisement) ? $advertisement->advertisements_end_date : '')); ?>">
                    <?php if($errors->first('advertisements_end_date')): ?>
                      <div class="invalid-feedback"><?php echo e($errors->first('advertisements_end_date')); ?></div>
                    <?php endif; ?>
                  </div>
                </div>
                
                 <!-- position field  -->
                <div class="form-group row">
                    <label class="col-md-3 col-form-label" for="advertisements_position"><?php echo e(__('general::lang.position')); ?><span class="text-danger"> *</span></label>
                    <div class="col-md-6">
                    <input class="form-control <?php echo e($errors->first('advertisements_position') ? 'is-invalid' : ''); ?>" id="advertisements_position" type="text" name="advertisements_position"
                    placeholder="<?php echo e(__('general::lang.position')); ?>" value="<?php echo e(old('advertisements_position', isset($advertisement) ? $advertisement->advertisements_position : 10000)); ?>">
                    <?php if($errors->first('advertisements_position')): ?>
                        <div class="invalid-feedback"><?php echo e($errors->first('advertisements_position')); ?></div>
                    <?php endif; ?>
                    </div>
                </div>

                <div class="form-group row">
                    <label class="col-md-3 col-form-label"><?php echo e(__('general::lang.status')); ?><span class="text-danger"> *</span></label>
                    <div class="col-md-9 col-form-label">
                      <?php
                        $status = old('advertisements_status', isset($advertisement) ? $advertisement->advertisements_status : 1);
                      ?>
                       <input type="hidden" id="advertisements_status_input" name="advertisements_status" value="<?php echo e($status); ?>">
                       <input type="checkbox" name="advertisements_statuss" id="advertisements_status"  <?php echo e($status ? 'checked' : ''); ?>  data-on=" <?php echo e(__('general::lang.active')); ?>" data-off=" <?php echo e(__('general::lang.stopped')); ?>" data-toggle="toggle" data-onstyle="success" data-offstyle="danger" data-width="80px" onChange="changeStatusInput('advertisements')">
                      <?php if($errors->first('advertisements_status')): ?>
                        <div class="invalid-feedback"><?php echo e($errors->first('advertisements_status')); ?></div>
                      <?php endif; ?>
                    </div>
                  </div>


              </div>
            </div>
          </div>

            
            <?php $__currentLoopData = $langs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lang): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="tab-pane fade <?php echo e($activeLocale == $lang->locale ? 'show active' : ''); ?>" id="<?php echo e($lang->locale); ?>" role="tabpanel" aria-labelledby="<?php echo e($lang->locale); ?>-tab">

                <div class="form-group row">
                    <label class="col-md-3 col-form-label" for="advertisements_url"><?php echo e(__('general::lang.link')); ?><span class="text-danger">  </span></label>
                    <div class="col-md-9">
                      <input class="form-control <?php echo e($errors->first($lang->locale .'.advertisements_url') ? 'is-invalid' : ''); ?>" id="advertisements_url" type="text" name="<?php echo e($lang->locale .'[advertisements_url]'); ?>" placeholder="<?php echo e(__('general::lang.link')); ?>"
                       value="<?php echo e(old($lang->locale .'.advertisements_url', isset($advertisement) ? $advertisement->translate($lang->locale)->advertisements_url : '')); ?>">
                      <?php if($errors->first($lang->locale .'.advertisements_url')): ?>
                        <div class="invalid-feedback"><?php echo e($errors->first($lang->locale .'.advertisements_url')); ?></div>
                      <?php endif; ?>
                    </div>
                </div>

                <div class="form-group row">
                    <label class="col-md-3 col-form-label" for="advertisements_web_img"><?php echo e(__('general::lang.web_img')); ?><span class="text-danger"> </span></label>
                    <div class="col-md-9">

                      <?php echo $__env->make('general::layouts.includes.imagePreviewLang',
                      ['name' => 'advertisements_web_img', 'value' => isset($advertisement) ? $advertisement->translate($lang->locale)->advertisements_web_img : null,'type'=>'advertisements','lang'=>$lang->locale ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                      <div class="invalid-feedback d-block fb-700"><?php echo e(__('general::lang.imageValidate',['height'=> '450px','width'=> '1250px'])); ?></div>
                      <?php if($errors->first($lang->locale .'.advertisements_web_img')): ?>
                        <div class="invalid-feedback"><?php echo e($errors->first($lang->locale .'.advertisements_web_img')); ?></div>
                      <?php endif; ?>
                    </div>
                </div>

                <div class="form-group row">
                    <label class="col-md-3 col-form-label" for="advertisements_phone_img"><?php echo e(__('general::lang.phone_img')); ?><span class="text-danger"> *</span></label>
                    <div class="col-md-9">
                      <?php echo $__env->make('general::layouts.includes.imagePreviewLang',
                      ['name' => 'advertisements_phone_img', 'value' => isset($advertisement) ? $advertisement->translate($lang->locale)->advertisements_phone_img : null,'type'=>'advertisements','lang'=>$lang->locale], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                        <div class="invalid-feedback d-block fb-700"><?php echo e(__('general::lang.imageValidate',['height'=> '250px','width'=> '400px'])); ?></div>
                        <?php if($errors->first($lang->locale .'.advertisements_phone_img')): ?>
                            <div class="invalid-feedback"><?php echo e($errors->first($lang->locale .'.advertisements_phone_img')); ?></div>
                        <?php endif; ?>
                    </div>
                </div>

            </div>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

        </div>


    </div>
  </div>
</div>

<?php $__env->startSection('script'); ?>
  <script type="text/javascript">

    $(document).ready(function(){
        // Initialize File Input Plugin
        $("#advertisementImage").fileinput({
            'showUpload':false,
            'showCancel':false,
            'previewFileType':'any',
            theme: "fa",
            language: "<?php echo e($dir == 'rtl' ? 'ar' : ''); ?>",
            required: "<?php echo e(isset($advertisement) ? false : true); ?>",
            rtl: "<?php echo e($dir == 'rtl' ? true : false); ?>",
            autoReplace: true,
            overwriteInitial: false,
            allowedFileTypes: ['image'],
            // maxFileCount: 5
        });

        // Delete Old Images individually
        $('.deleteAdvertisementImage').click(function(){
            let btn =  $(this);
            let con = confirm("Are you sure?");

            if (con) {
                const filename = $(this).data('name');
                $.ajax({
                    url: "<?php echo e(route('admin.advertisements.deleteImage')); ?>",
                    method: 'POST',
                    dataType: 'json', // type of response data
                    data: {
                        filename
                    },
                    success: function (data) {   // success callback function
                        if (data.msg == 1) {
                            btn.closest('.advertisementImageContainer').hide("slow");
                        } else if(data.msg == 0) {
                            alert("Something wrong happens, try again!")
                        }
                    }
                });
            }

        });
    });
  </script>

<?php $__env->stopSection(); ?>
<?php /**PATH /home/vivacoupon/public_html/system.vivacoupon.com/system/Modules/General/Resources/views/admin/advertisements/form.blade.php ENDPATH**/ ?>