
<?php
  $activeLocale = old('activeLocale', 'general');
  $activeLocale = 'general';
?>

<div class="card-body">
  <?php echo $__env->make('general::layouts.includes.messages', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

  
  <ul class="nav nav-tabs" id="langsTabs" role="tablist">
    <li class="nav-item d-none">
      <a class="nav-link " id="general-tab" data-toggle="tab" href="#general" role="tab" aria-controls="general" aria-selected="true">
      <?php echo e(__('general::lang.general')); ?></a>
    </li>
    <?php $__currentLoopData = $langs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lang): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
      <li class="nav-item">
        <a class="nav-link <?php echo e($loop->first ? 'active' : ''); ?>" id="<?php echo e($lang->locale); ?>-tab" data-toggle="tab" href="#<?php echo e($lang->locale); ?>"
          role="tab" aria-controls="<?php echo e($lang->locale); ?>" aria-selected="false">
          <?php echo e(__('general::lang.'. $lang->locale)); ?>

        </a>
      </li>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
  </ul>

  
  <div class="tab-content " id="langsTabsContent">
    <div class="tab-pane fade    " id="general" role="tabpanel" aria-labelledby="general-tab">
      <div class="row">
        <div class="col-lg-9">

          <div class="form-group row">
            <label class="col-md-3 col-form-label"><?php echo e(__('general::lang.status')); ?><span class="text-danger"> *</span></label>
            <div class="col-md-9 col-form-label">
              <?php
                $status = old('infos_status', isset($info) ? $info->infos_status : 1);
              ?>
              <div class="form-check form-check-inline mr-1">
                <input class="form-check-input" id="active" type="radio" value="1" name="infos_status" <?php echo e($status == 1 ? 'checked' : ''); ?>>
                <label class="form-check-label" for="active"><?php echo e(__('general::lang.active')); ?></label>
              </div>
              <div class="form-check form-check-inline mr-1">
                <input class="form-check-input" id="stopped" type="radio" value="0" name="infos_status" <?php echo e($status == 0 ? 'checked' : ''); ?>>
                <label class="form-check-label" for="stopped"><?php echo e(__('general::lang.stopped')); ?></label>
              </div>
              <?php if($errors->first('infos_status')): ?>
                <div class="invalid-feedback"><?php echo e($errors->first('infos_status')); ?></div>
              <?php endif; ?>
            </div>
          </div>

        </div>
      </div>
    </div>
    
    <?php $__currentLoopData = $langs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lang): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
    <div class="tab-pane fade <?php echo e($loop->first ? 'show active' : ''); ?> " id="<?php echo e($lang->locale); ?>" role="tabpanel" aria-labelledby="<?php echo e($lang->locale); ?>-tab">


        <div class="row">

          <div class="col-lg-12">

              <div class="form-group row">
                <label class="col-md-2 col-form-label d-none"><?php echo e(__('general::lang.title')); ?><span class="text-danger"> *</span></label>
                <div class="col-md-10">
                  <input type="hidden" id="infos_title" class="form-control <?php echo e($errors->first($lang->locale .'.infos_title') ? 'is-invalid' : ''); ?>" name="<?php echo e($lang->locale .'[infos_title]'); ?>" value="<?php echo e(old($lang->locale .'.infos_title', isset($info) && $info->translate($lang->locale) ? $info->translate($lang->locale)->infos_title : '')); ?>"  placeholder="<?php echo e(__('general::lang.title')); ?>">
                  <?php if($errors->first($lang->locale .'.infos_title')): ?>
                    <div class="invalid-feedback"><?php echo e($errors->first($lang->locale .'.infos_title')); ?></div>
                  <?php endif; ?>
                </div>
              </div>


          </div>

          <div class="col-lg-12">


              <div class="form-group row">
                <label class="col-md-2 col-form-label"><?php echo e(__('general::lang.info_desc')); ?><span class="text-danger"> *</span></label>
                <div class="col-md-10">
                  <textarea id="<?php echo e($lang->locale); ?>-ckeditor" class="form-control ckeditor <?php echo e($errors->first($lang->locale .'.infos_desc') ? 'is-invalid' : ''); ?>"
                   name="<?php echo e($lang->locale .'[infos_desc]'); ?>" rows="9" placeholder="<?php echo e(__('general::lang.info_desc')); ?>"
                   ><?php echo e(old($lang->locale .'.infos_desc', isset($info) && $info->translate($lang->locale) ? $info->translate($lang->locale)->infos_desc : '')); ?></textarea>
                  <?php if($errors->first($lang->locale .'.infos_desc')): ?>
                    <div class="invalid-feedback"><?php echo e($errors->first($lang->locale .'.infos_desc')); ?></div>
                  <?php endif; ?>
                </div>
              </div>


          </div>

        </div>



      </div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
  </div>
</div>
<?php /**PATH /home/vivacoupon/public_html/system.vivacoupon.com/system/Modules/General/Resources/views/admin/infos/form.blade.php ENDPATH**/ ?>