
<div class="card-body">
	<?php echo $__env->make('general::layouts.includes.messages', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
  <div class="row">
    <div class="col-lg-9">
      <div class="form-group row">
        <label class="col-md-3 col-form-label" for="name"><?php echo e(__('general::lang.name')); ?><span class="text-danger"> *</span></label>
        <div class="col-md-9">
          <input class="form-control <?php echo e($errors->first('name') ? 'is-invalid' : ''); ?>" id="name" type="text" name="name" placeholder="<?php echo e(__('general::lang.name')); ?>"
           value="<?php echo e(old('name', isset($admin) ? $admin->name : '')); ?>">
          <?php if($errors->first('name')): ?>
            <div class="invalid-feedback"><?php echo e($errors->first('name')); ?></div>
          <?php endif; ?>
        </div>
      </div>
      <div class="form-group row">
        <label class="col-md-3 col-form-label" for="email"><?php echo e(__('general::lang.email')); ?><span class="text-danger"> *</span></label>
        <div class="col-md-9">
          <input class="form-control <?php echo e($errors->first('email') ? 'is-invalid' : ''); ?>" id="email" type="email" name="email" placeholder="<?php echo e(__('general::lang.email')); ?>"
           value="<?php echo e(old('email', isset($admin) ? $admin->email : '')); ?>">
          <?php if($errors->first('email')): ?>
            <div class="invalid-feedback"><?php echo e($errors->first('email')); ?></div>
          <?php endif; ?>
        </div>
      </div>
      <div class="form-group row">
        <label class="col-md-3 col-form-label" for="password"><?php echo e(__('general::lang.password')); ?><span class="text-danger"> *</span></label>
        <div class="col-md-9">
          <input class="form-control <?php echo e($errors->first('password') ? 'is-invalid' : ''); ?>" id="password" type="password" name="password" placeholder="<?php echo e(__('general::lang.password')); ?>">
          <?php if($errors->first('password')): ?>
            <div class="invalid-feedback"><?php echo e($errors->first('password')); ?></div>
          <?php endif; ?>
        </div>
      </div>
      <div class="form-group row">
        <label class="col-md-3 col-form-label" for="password_confirmation"><?php echo e(__('general::lang.confirmPassword')); ?><span class="text-danger"> *</span></label>
        <div class="col-md-9">
          <input class="form-control <?php echo e($errors->first('password_confirmation') ? 'is-invalid' : ''); ?>" id="password_confirmation" type="password"
           name="password_confirmation" placeholder="<?php echo e(__('general::lang.confirmPassword')); ?>">
          <?php if($errors->first('password_confirmation')): ?>
            <div class="invalid-feedback"><?php echo e($errors->first('password_confirmation')); ?></div>
          <?php endif; ?>
        </div>
      </div>
      <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('create admins')): ?>
      <div class="form-group row">
        <label class="col-md-3 col-form-label" for="admins_position"><?php echo e(__('general::lang.position')); ?><span class="text-danger"> *</span></label>
        <div class="col-md-9">
          <input class="form-control <?php echo e($errors->first('admins_position') ? 'is-invalid' : ''); ?>" id="admins_position" type="text" name="admins_position"
           placeholder="<?php echo e(__('general::lang.position')); ?>" value="<?php echo e(old('admins_position', isset($admin) ? $admin->admins_position : 1)); ?>">
          <?php if($errors->first('admins_position')): ?>
            <div class="invalid-feedback"><?php echo e($errors->first('admins_position')); ?></div>
          <?php endif; ?>
        </div>
      </div>

      <div class="form-group row">
        <label class="col-md-3 col-form-label" for="roles"><?php echo e(__('general::lang.roles')); ?><span class="text-danger"> *</span></label>
        <div class="col-md-9">
          <select class="form-control select2 <?php echo e($errors->first('roles') ? 'is-invalid' : ''); ?>" id="roles" name="roles[]"
           placeholder="<?php echo e(__('general::lang.roles')); ?>" multiple>
            <option value=""></option>
            <?php $__currentLoopData = $roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
              <option value="<?php echo e($role->name); ?>" <?php echo e(isset($admin) && $admin->hasRole($role->name) ? 'selected' : ''); ?>><?php echo e($role->name); ?></option>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
          </select>
          <?php if($errors->first('roles')): ?>
            <div class="invalid-feedback"><?php echo e($errors->first('roles')); ?></div>
          <?php endif; ?>
        </div>
      </div>

      <div class="form-group row">
        <label class="col-md-3 col-form-label"><?php echo e(__('general::lang.status')); ?><span class="text-danger"> *</span></label>
        <div class="col-md-9 col-form-label">
          <?php
            $status = old('admins_status', isset($admin) ? $admin->admins_status : 1);
          ?>
          <div class="form-check form-check-inline mr-1">
            <input class="form-check-input" id="active" type="radio" value="1" name="admins_status" <?php echo e($status == 1 ? 'checked' : ''); ?>>
            <label class="form-check-label" for="active"><?php echo e(__('general::lang.active')); ?></label>
          </div>
          <div class="form-check form-check-inline mr-1">
            <input class="form-check-input" id="stopped" type="radio" value="0" name="admins_status" <?php echo e($status == 0 ? 'checked' : ''); ?>>
            <label class="form-check-label" for="stopped"><?php echo e(__('general::lang.stopped')); ?></label>
          </div>
          <?php if($errors->first('admins_status')): ?>
            <div class="invalid-feedback"><?php echo e($errors->first('admins_status')); ?></div>
          <?php endif; ?>
        </div>
      </div>
      <?php else: ?>
        <input   type="hidden" name="admins_position" value="<?php echo e(isset($admin) ? $admin->admins_position : ''); ?>">
        <input   type="hidden" name="admins_type" value="<?php echo e(isset($admin) ? $admin->admins_type : ''); ?>">
        <input   type="hidden" name="admins_status" value="<?php echo e(isset($admin) ? $admin->admins_status : ''); ?>">
        <?php $__currentLoopData = $roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php if($admin->hasRole($role->name)): ?>
                <input   type="hidden" name="roles[]" value="<?php echo e($role->name); ?>">
            <?php endif; ?>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

       <?php endif; ?>
    </div>
  </div>
</div>
<?php /**PATH /home2/trainopi/public_html/system-primocoupon-com/system/Modules/General/Resources/views/admin/admins/form.blade.php ENDPATH**/ ?>