
<?php
  $activeLocale = old('activeLocale', 'general');
  $activeLocale = 'general';
?>

<div class="card-body">
  <?php echo $__env->make('main::layouts.includes.messages', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

  
  <ul class="nav nav-tabs" id="langsTabs" role="tablist">
    <li class="nav-item">
      <a class="nav-link <?php echo e($activeLocale == 'general' ? 'active' : ''); ?>" id="general-tab" data-toggle="tab" href="#general" role="tab" aria-controls="general" aria-selected="true">
      <?php echo e(__('main::lang.general')); ?></a>
    </li>
    <?php $__currentLoopData = $langs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lang): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
      <li class="nav-item">
        <a class="nav-link <?php echo e($activeLocale == $lang->locale ? 'active' : ''); ?>" id="<?php echo e($lang->locale); ?>-tab" data-toggle="tab" href="#<?php echo e($lang->locale); ?>"
          role="tab" aria-controls="<?php echo e($lang->locale); ?>" aria-selected="false">
          <?php echo e(__('main::lang.'. $lang->locale)); ?>

        </a>
      </li>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
  </ul>

  
  <div class="tab-content" id="langsTabsContent">
    <div class="tab-pane fade <?php echo e($activeLocale == 'general' ? 'show active' : ''); ?>" id="general" role="tabpanel" aria-labelledby="general-tab">
      <div class="row">
        <div class="col-lg-9">

          <div class="form-group row ">
              <label class="col-md-3 col-form-label" for="categories_image"><?php echo e(__('main::lang.img')); ?><span class="text-danger">  </span></label>
              <div class="col-md-9">
                <?php echo $__env->make('main::layouts.includes.imagePreview', ['name' => 'categories_image', 'value' => isset($category) ? $category->categories_image : null,'type'=>'categories'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <?php if($errors->first('categories_image')): ?>
                  <div class="invalid-feedback"><?php echo e($errors->first('categories_image')); ?></div>
                <?php endif; ?>
              </div>
          </div>
          <?php if(isset($category) && $category->categories_image): ?>
          <div class="form-group row">
              <label class="col-md-3 col-form-label"><?php echo e(__('main::lang.delete_image')); ?><span class="text-danger">
                     </span></label>
              <div class="col-md-9 col-form-label">
                  <div class="form-check form-check-inline mr-1">
                      <input class="form-check-input" id="delete_image" type="checkbox" value="1"name="delete_image"  >
                   </div>

              </div>
          </div>
          <?php endif; ?>
          
          <div class="form-group row">
            <label class="col-md-3 col-form-label" for="categories_code"><?php echo e(__('main::lang.categories_code')); ?><span class="text-danger"> *</span></label>
            <div class="col-md-9">
              <input class="form-control <?php echo e($errors->first('categories_code') ? 'is-invalid' : ''); ?>" id="categories_code" type="text" name="categories_code"
               placeholder="<?php echo e(__('main::lang.categories_code')); ?>" value="<?php echo e(old('categories_code', isset($category) ? $category->categories_code : '')); ?>">
              <?php if($errors->first('categories_code')): ?>
                <div class="invalid-feedback"><?php echo e($errors->first('categories_code')); ?></div>
              <?php endif; ?>
            </div>
          </div>
          <div class="form-group row">
            <label class="col-md-3 col-form-label" for="categories_position"><?php echo e(__('main::lang.position')); ?><span class="text-danger"> *</span></label>
            <div class="col-md-9">
              <input class="form-control <?php echo e($errors->first('categories_position') ? 'is-invalid' : ''); ?>" id="categories_position" type="text" name="categories_position"
               placeholder="<?php echo e(__('main::lang.position')); ?>" value="<?php echo e(old('categories_position', isset($category) ? $category->categories_position : 1)); ?>">
              <?php if($errors->first('categories_position')): ?>
                <div class="invalid-feedback"><?php echo e($errors->first('categories_position')); ?></div>
              <?php endif; ?>
            </div>
          </div>

          <div class="form-group row">
            <label class="col-md-3 col-form-label"><?php echo e(__('main::lang.status')); ?><span class="text-danger"> *</span></label>
            <div class="col-md-9 col-form-label">
              <?php
                $status = old('categories_status', isset($category) ? $category->categories_status : 1);
              ?>
              <input type="hidden" id="categories_status_input" name="categories_status" value="<?php echo e($status); ?>">
              <input type="checkbox" name="categories_statuss" id="categories_status"  <?php echo e($status ? 'checked' : ''); ?>  data-on=" <?php echo e(__('main::lang.active')); ?>" data-off=" <?php echo e(__('main::lang.stopped')); ?>" data-toggle="toggle" data-onstyle="success" data-offstyle="danger" data-width="80px" onChange="changeStatusInput('categories')">

              <?php if($errors->first('categories_status')): ?>
                <div class="invalid-feedback"><?php echo e($errors->first('categories_status')); ?></div>
              <?php endif; ?>
            </div>
          </div>

        </div>
      </div>
    </div>
    
    <?php $__currentLoopData = $langs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lang): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
      <div class="tab-pane fade <?php echo e($activeLocale == $lang->locale ? 'show active' : ''); ?>" id="<?php echo e($lang->locale); ?>" role="tabpanel" aria-labelledby="<?php echo e($lang->locale); ?>-tab">

        <div class="row">

          <div class="col-lg-9">
            <p class="text-primary h6"><?php echo e(__('main::lang.categoryDetails')); ?></p>
            <div class="form-group row">
              <label class="col-md-2 col-form-label"><?php echo e(__('main::lang.name')); ?><span class="text-danger"> *</span></label>

              <div class="col-md-10">
                <input class="form-control <?php echo e($errors->first($lang->locale .'.categories_name') ? 'is-invalid' : ''); ?>" type="text"
                 name="<?php echo e($lang->locale .'[categories_name]'); ?>" placeholder="<?php echo e(__('main::lang.name')); ?>"
                 value="<?php echo e(old($lang->locale .'.categories_name', isset($category) ? $category->translate($lang->locale)->categories_name : '')); ?>">
                <?php if($errors->first($lang->locale .'.categories_name')): ?>
                  <div class="invalid-feedback"><?php echo e($errors->first($lang->locale .'.categories_name')); ?></div>
                <?php endif; ?>
              </div>
            </div>

            <div class="form-group row">
                <label class="col-md-2 col-form-label"><?php echo e(__('main::lang.seo_title')); ?><span class="text-danger">  </span></label>
                <div class="col-md-10">
                    <input class="form-control <?php echo e($errors->first($lang->locale .'.categories_seo_title') ? 'is-invalid' : ''); ?>" type="text"
                     name="<?php echo e($lang->locale .'[categories_seo_title]'); ?>" placeholder="<?php echo e(__('main::lang.seo_title')); ?>"
                     value="<?php echo e(old($lang->locale .'.categories_seo_title', isset($category) ? $category->translate($lang->locale)->categories_seo_title : '')); ?>">
                    <?php if($errors->first($lang->locale .'.categories_seo_title')): ?>
                      <div class="invalid-feedback"><?php echo e($errors->first($lang->locale .'.categories_seo_title')); ?></div>
                    <?php endif; ?>
                </div>
            </div>
            <div class="form-group row">
                <label class="col-md-2 col-form-label"><?php echo e(__('main::lang.seo_keyword')); ?><span class="text-danger">  </span></label>

                <div class="col-md-10">
                    <input class="form-control <?php echo e($errors->first($lang->locale .'.categories_seo_keyword') ? 'is-invalid' : ''); ?>" type="text"
                    name="<?php echo e($lang->locale .'[categories_seo_keyword]'); ?>" placeholder="<?php echo e(__('main::lang.seo_keyword')); ?>"
                    value="<?php echo e(old($lang->locale .'.categories_seo_keyword', isset($category) ? $category->translate($lang->locale)->categories_seo_keyword : '')); ?>" data-role="tagsinput">
                    <?php if($errors->first($lang->locale .'.categories_seo_keyword')): ?>
                    <div class="invalid-feedback"><?php echo e($errors->first($lang->locale .'.categories_seo_keyword')); ?></div>
                    <?php endif; ?>
                </div>
            </div>

            <div class="form-group row">
                <label class="col-md-2 col-form-label"><?php echo e(__('main::lang.seo_desc')); ?></label>
                <div class="col-md-10">
                    <textarea   class="  form-control <?php echo e($errors->first($lang->locale .'.categories_seo_desc') ? 'is-invalid' : ''); ?>"
                      name="<?php echo e($lang->locale .'[categories_seo_desc]'); ?>"
                        id="<?php echo e($lang->locale .'[categories_seo_desc]'); ?>"
                        placeholder="<?php echo e(__('main::lang.seo_desc')); ?>"
                        rows="3"><?php echo e(old($lang->locale .'.categories_seo_desc', isset($category) ? $category->translate($lang->locale)->categories_seo_desc : '')); ?></textarea>
                    <?php if($errors->first($lang->locale .'.categories_seo_desc')): ?>
                      <div class="invalid-feedback"><?php echo e($errors->first($lang->locale .'.categories_seo_desc')); ?></div>
                    <?php endif; ?>
                </div>
            </div>
          </div>

        </div>

      <div class="row comparisonItems <?php echo e(isset($allow) && $allow == 1 ? '' : 'd-none'); ?>"  >

          <div class="col-lg-9">
            <p class="text-primary h6"><?php echo e(__('main::lang.comparisonItems')); ?>  </p>

            <div class="form-group row">
              <label class="col-md-3 col-form-label"><?php echo e(__('main::lang.item1')); ?><span class="text-danger"> *</span></label>

              <div class="col-md-9">
                <input class="form-control <?php echo e($errors->first($lang->locale .'.categories_comparison_item1') ? 'is-invalid' : ''); ?>" type="text"
                 name="<?php echo e($lang->locale .'[categories_comparison_item1]'); ?>" placeholder="<?php echo e(__('main::lang.item1')); ?>"
                 value="<?php echo e(old($lang->locale .'.categories_comparison_item1', isset($category->CategoryComparison) ? $category->CategoryComparison->translate($lang->locale)->categories_comparison_item1 : '')); ?>">
                <?php if($errors->first($lang->locale .'.categories_comparison_item1')): ?>
                  <div class="invalid-feedback"><?php echo e($errors->first($lang->locale .'.categories_comparison_item1')); ?></div>
                <?php endif; ?>
              </div>
            </div>

            <div class="form-group row">
              <label class="col-md-3 col-form-label"><?php echo e(__('main::lang.item2')); ?><span class="text-danger"> *</span></label>

              <div class="col-md-9">
                <input class="form-control <?php echo e($errors->first($lang->locale .'.categories_comparison_item2') ? 'is-invalid' : ''); ?>" type="text"
                 name="<?php echo e($lang->locale .'[categories_comparison_item2]'); ?>" placeholder="<?php echo e(__('main::lang.item2')); ?>"
                 value="<?php echo e(old($lang->locale .'.categories_comparison_item2', isset($category->CategoryComparison) ? $category->CategoryComparison->translate($lang->locale)->categories_comparison_item2 : '')); ?>">
                <?php if($errors->first($lang->locale .'.categories_comparison_item2')): ?>
                  <div class="invalid-feedback"><?php echo e($errors->first($lang->locale .'.categories_comparison_item2')); ?></div>
                <?php endif; ?>
              </div>
            </div>


            <div class="form-group row">
              <label class="col-md-3 col-form-label"><?php echo e(__('main::lang.item3')); ?><span class="text-danger"> *</span></label>

              <div class="col-md-9">
                <input class="form-control <?php echo e($errors->first($lang->locale .'.categories_comparison_item3') ? 'is-invalid' : ''); ?>" type="text"
                 name="<?php echo e($lang->locale .'[categories_comparison_item3]'); ?>" placeholder="<?php echo e(__('main::lang.item3')); ?>"
                 value="<?php echo e(old($lang->locale .'.categories_comparison_item3', isset($category->CategoryComparison) ? $category->CategoryComparison->translate($lang->locale)->categories_comparison_item3 : '')); ?>">
                <?php if($errors->first($lang->locale .'.categories_comparison_item3')): ?>
                  <div class="invalid-feedback"><?php echo e($errors->first($lang->locale .'.categories_comparison_item3')); ?></div>
                <?php endif; ?>
              </div>
            </div>


            <div class="form-group row">
              <label class="col-md-3 col-form-label"><?php echo e(__('main::lang.item4')); ?><span class="text-danger"> *</span></label>

              <div class="col-md-9">
                <input class="form-control <?php echo e($errors->first($lang->locale .'.categories_comparison_item4') ? 'is-invalid' : ''); ?>" type="text"
                 name="<?php echo e($lang->locale .'[categories_comparison_item4]'); ?>" placeholder="<?php echo e(__('main::lang.item4')); ?>"
                 value="<?php echo e(old($lang->locale .'.categories_comparison_item4', isset($category->CategoryComparison) ? $category->CategoryComparison->translate($lang->locale)->categories_comparison_item4 : '')); ?>">
                <?php if($errors->first($lang->locale .'.categories_comparison_item4')): ?>
                  <div class="invalid-feedback"><?php echo e($errors->first($lang->locale .'.categories_comparison_item4')); ?></div>
                <?php endif; ?>
              </div>
            </div>


            <div class="form-group row">
              <label class="col-md-3 col-form-label"><?php echo e(__('main::lang.item5')); ?><span class="text-danger"> *</span></label>

              <div class="col-md-9">
                <input class="form-control <?php echo e($errors->first($lang->locale .'.categories_comparison_item5') ? 'is-invalid' : ''); ?>" type="text"
                 name="<?php echo e($lang->locale .'[categories_comparison_item5]'); ?>" placeholder="<?php echo e(__('main::lang.item5')); ?>"
                 value="<?php echo e(old($lang->locale .'.categories_comparison_item5', isset($category->CategoryComparison) ? $category->CategoryComparison->translate($lang->locale)->categories_comparison_item5 : '')); ?>">
                <?php if($errors->first($lang->locale .'.categories_comparison_item5')): ?>
                  <div class="invalid-feedback"><?php echo e($errors->first($lang->locale .'.categories_comparison_item5')); ?></div>
                <?php endif; ?>
              </div>
            </div>


            <div class="form-group row">
              <label class="col-md-3 col-form-label"><?php echo e(__('main::lang.item6')); ?><span class="text-danger"> *</span></label>

              <div class="col-md-9">
                <input class="form-control <?php echo e($errors->first($lang->locale .'.categories_comparison_item6') ? 'is-invalid' : ''); ?>" type="text"
                 name="<?php echo e($lang->locale .'[categories_comparison_item6]'); ?>" placeholder="<?php echo e(__('main::lang.item6')); ?>"
                 value="<?php echo e(old($lang->locale .'.categories_comparison_item6', isset($category->CategoryComparison) ? $category->CategoryComparison->translate($lang->locale)->categories_comparison_item6 : '')); ?>">
                <?php if($errors->first($lang->locale .'.categories_comparison_item6')): ?>
                  <div class="invalid-feedback"><?php echo e($errors->first($lang->locale .'.categories_comparison_item6')); ?></div>
                <?php endif; ?>
              </div>
            </div>


          </div>

        </div>

      </div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
  </div>
</div>
<?php $__env->startSection('style'); ?>
<link rel="stylesheet" href="<?php echo e(asset('front/css/tagsinput.css')); ?>">
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
  <script src="<?php echo e(asset('front/js/tagsinput.js')); ?>"></script>
  <script>
    function checkIfCategoryIsLeaf(categories_id){
      <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $categ): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        if(categories_id == "<?php echo e($categ->categories_id); ?>"){
          <?php if($categ->categories_allow_comparison == 1): ?>
            alert('<?php echo e(__("main::lang.comparisonDateWillDeleted")); ?>')
          <?php endif; ?>
          <?php if($categ->isLeaf()): ?>
            return true ;
          <?php else: ?>
            <?php $__currentLoopData = $allLeavesIds; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $leaf): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                if(categories_id == "<?php echo e($leaf->categories_parent_id); ?>"){
                    return true ;
                }
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            return false ;
          <?php endif; ?>
        }
      <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    }
    function checkIfCategoryIsRoot(categories_id){
      <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $categ): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        if(categories_id == "<?php echo e($categ->categories_id); ?>"){
          <?php if($categ->isRoot()): ?>
            return true ;
          <?php else: ?>
            return false ;
          <?php endif; ?>
        }
      <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    }
    function checkParentCategory(categories_id){
      if(categories_id){
        if(checkIfCategoryIsLeaf(categories_id)){

            $('#categories_allow_comparison').removeClass('d-none')
            // $('.badge_div').removeClass('d-none');

            <?php if(isset($category) && $category->categories_allow_comparison == '1'): ?>
                $('.comparisonItems').removeClass('d-none');
            <?php else: ?>
                $("input[name='categories_allow_comparison'][value='0']").prop('checked', true);
                $('.comparisonItems').addClass('d-none');
            <?php endif; ?>
        }else{
            $('#categories_allow_comparison').addClass('d-none')
            $("input[name='categories_allow_comparison'][value='0']").prop('checked', true);
            $('.comparisonItems').addClass('d-none');
            // $('.badge_div').addClass('d-none');

        }
        $('#categories_allow_ratings').addClass('d-none')
        $("input[name='categories_allow_ratings'][value='0']").prop('checked', true);
      }else{
        $('#categories_allow_comparison').addClass('d-none')
        $('#categories_allow_ratings').removeClass('d-none')
        // $("input[name='categories_allow_comparison'][value='0']").prop('checked', true);
        //   $('.comparisonItems').addClass('d-none');
      }
    }
    categories_id =  $("#categories").val();
    checkParentCategory(categories_id)

    $("#categories").change(function (){
        categories_id =  $("#categories").val();
        checkParentCategory(categories_id)
    });

    <?php if(isset($category)): ?>
      <?php if($category->isLeaf()): ?>
            $('#categories_allow_comparison').removeClass('d-none')
            // $('.badge_div').removeClass('d-none');
            <?php if(isset($category) && $category->categories_allow_comparison == '1'): ?>
                $('.comparisonItems').removeClass('d-none');
            <?php else: ?>
                $('.comparisonItems').addClass('d-none');
            <?php endif; ?>
      <?php else: ?>
        $('#categories_allow_comparison').addClass('d-none')
        $("input[name='categories_allow_comparison'][value='0']").prop('checked', true);
        $('.comparisonItems').addClass('d-none');
        // $('.badge_div').addClass('d-none');
      <?php endif; ?>

      <?php if($category->isRoot()): ?>
        $('#categories_allow_ratings').removeClass('d-none')
      <?php else: ?>
        $('#categories_allow_ratings').addClass('d-none')
        $("input[name='categories_allow_ratings'][value='0']").prop('checked', true);
      <?php endif; ?>
    <?php endif; ?>

    $("#allowed").change(function (){
        allowed =  $("#allowed").val();
        if(allowed == 1){
          $('.comparisonItems').removeClass('d-none');
        }else{
          $('.comparisonItems').addClass('d-none');
        }
      });
    $("#notAllowed").change(function (){
     allowed =  $("#notAllowed").val();
        if(allowed == 1){
          $('.comparisonItems').removeClass('d-none');
        }else{
          $('.comparisonItems').addClass('d-none');
        }
    });

    function changeToggleInput(type){
        if(document.getElementById(type).checked){
            $('#'+type+'_input').val('1')
        }else{
            $('#'+type+'_input').val('0')
        }
    }
  </script>
<?php $__env->stopSection(); ?>
<?php /**PATH /home/vivacoupon/public_html/system.vivacoupon.com/system/Modules/Main/Resources/views/admin/categories/form.blade.php ENDPATH**/ ?>