<?php $__env->startPush('css'); ?>
<style>

	h2,
	h5,
	.h2,
	.h5 {
		font-family: inherit;
		font-weight: 600;
		line-height: 1.5;
		margin-bottom: .5rem;
		color: #32325d;
	}
 

	.bg-danger {
		background-color: #f5365c !important;
	}

	@media (min-width: 1200px) {
	
		.justify-content-xl-between {
			justify-content: space-between !important;
		}
	}

	.font-weight-bold {
		font-weight: 600 !important;
	}


	a.text-success:hover,
	a.text-success:focus {
		color: #24a46d !important;
	}

	.text-warning {
	color: #fb6340 !important;
	}

	a.text-warning:hover,
	a.text-warning:focus {
		color: #fa3a0e !important;
	}

	.text-danger {
	color: #f5365c !important;
	}

	a.text-danger:hover,
	a.text-danger:focus {
		color: #ec0c38 !important;
	}

	.text-white {
	color: #fff !important;
	}

	a.text-white:hover,
	a.text-white:focus {
	color: #e6e6e6 !important;
	}

	.text-muted {
		color: #8898aa !important;
	}
 
	figcaption,
	main {
		display: block;
	}

	main {
		overflow: hidden;
	}

	.bg-yellow {
		background-color: #ffd600 !important;
	}

	.icon {
		width: 3rem;
		height: 3rem;
	}

	.icon i {
	font-size: 2.25rem;
	}

	.icon-shape {
		display: inline-flex;
		padding: 35px;
		text-align: center;
		border-radius: 50%;
		align-items: center;
		justify-content: center;
	}

</style>
<?php $__env->stopPush(); ?> 
<?php $__env->startSection('main'); ?>
  <main class="main">

	<div class="container-fluid">
		<div class="animated fadeIn">

			<div class="row mt-4">
				<div class="col-xl-3 col-lg-6">
				  <div class=" card card-stats py-3 mb-4 mb-xl-0">
					<div class="card-body">
					  <div class="row">
						<div class="col">
						  <h5 class="card-title text-uppercase text-muted mb-0"><?php echo e(__('main::lang.stores')); ?></h5>
						  <span class="h2 font-weight-bold mb-0"><?php echo e($countStores); ?></span>
						</div>
						<div class="col-auto">
						  <div class="icon icon-shape bg-danger text-white rounded-circle shadow">
							<i class="fa fa-bar-chart"></i>
						  </div>
						</div>
					  </div>
 
					</div>
				  </div>
				</div>
				<div class="col-xl-3 col-lg-6">
				  <div class=" card card-stats py-3 mb-4 mb-xl-0">
					<div class="card-body">
					  <div class="row">
						<div class="col">
						  <h5 class="card-title text-uppercase text-muted mb-0"><?php echo e(__('main::lang.coupons')); ?></h5>
						  <span class="h2 font-weight-bold mb-0"><?php echo e($countCoupons); ?></span>
						</div>
						<div class="col-auto">
						  <div class="icon icon-shape bg-warning text-white rounded-circle shadow">
							<i class="fa fa-pie-chart"></i>
						  </div>
						</div>
					  </div>
					  
					</div>
				  </div>
				</div>
				<div class="col-xl-3 col-lg-6">
				  <div class=" card card-stats py-3 mb-4 mb-xl-0">
					<div class="card-body">
					  <div class="row">
						<div class="col">
						  <h5 class="card-title text-uppercase text-muted mb-0"><?php echo e(__('main::lang.customers')); ?></h5>
						  <span class="h2 font-weight-bold mb-0"><?php echo e($countCategories); ?></span>
						</div>
						<div class="col-auto">
						  <div class="icon icon-shape bg-yellow text-white rounded-circle shadow">
							<i class="fa fa-users"></i>
						  </div>
						</div>
					  </div>
					 
					</div>
				  </div>
				</div>
				<div class="col-xl-3 col-lg-6">
				  <div class=" card card-stats py-3 mb-4 mb-xl-0">
					<div class="card-body">
					  <div class="row">
						<div class="col">
						  <h5 class="card-title text-uppercase text-muted mb-0"><?php echo e(__('main::lang.categories')); ?></h5>
						  <span class="h2 font-weight-bold mb-0"><?php echo e($countCategories); ?></span>
						</div>
						<div class="col-auto">
						  <div class="icon icon-shape bg-info text-white rounded-circle shadow">
							<i class="fa fa-th-list"></i>
						  </div>
						</div>
					  </div>
					   
					</div>
				  </div>
				</div>
			</div>
			  
			<div class="row align-items-center mt-5">
				<div class="col-6">
					<div class="card  border-0">
						<div class="card-body text-center">
							<canvas id="countriesChart" style="height: 600px; "></canvas>
						</div>
					</div>
				</div>
				<div class="col-6">
					<div class="card  border-0">
						<div class="card-body text-center">
							<canvas id="categoriesChart" style="height: 600px; "></canvas>
 
						</div>
					</div>
				</div>
			</div>

		</div>
	</div>

  </main>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('js'); ?>
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
 
	function getRandomColor(){
		return "#" + Math.floor(Math.random()*16777215).toString(16);
	}
 
	const countriesChart = document.getElementById('countriesChart');

	new Chart(countriesChart, {
	type: 'bar',
	data: {
		labels: [
			<?php $__currentLoopData = $countries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $country): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
			'<?php echo e($country->countries_name); ?>',
			<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
		],
		datasets: [{
			label: '# <?php echo e(__("main::lang.stores")); ?>',
			data: [
				<?php $__currentLoopData = $countries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $country): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
				'<?php echo e(count($country->stores)); ?>',
				<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
			],
			backgroundColor: [
				<?php $__currentLoopData = $countries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $country): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
				getRandomColor(),
				<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
			],
			borderWidth: 1
		}]
	},
	options: {
		scales: {
		y: {
			beginAtZero: true
		}
		}
	}
	});

	const categoriesChart = document.getElementById('categoriesChart');

	new Chart(categoriesChart, {
	type: 'bar',
	data: {
		labels: [
			<?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
			'<?php echo e($category->categories_name); ?>',
			<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
		],
		datasets: [{
			label: '# <?php echo e(__("main::lang.stores")); ?>',
			data: [
				<?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
				'<?php echo e(count($category->stores)); ?>',
				<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
			],
			backgroundColor: [
				<?php $__currentLoopData = $countries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $country): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
				getRandomColor(),
				<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
			],
			borderWidth: 1
		}]
	},
	options: {
		scales: {
		y: {
			beginAtZero: true
		}
		}
	}
	});
 
  </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('general::layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home2/trainopi/public_html/system-primocoupon-com/system/Modules/General/Resources/views/admin/dashboard/home.blade.php ENDPATH**/ ?>