
<?php
  $activeLocale = old('activeLocale', 'general');
  $activeLocale = 'general';
?>

<div class="card-body">
  <?php echo $__env->make('main::layouts.includes.messages', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

  
  <ul class="nav nav-tabs" id="langsTabs" role="tablist">
    <li class="nav-item">
      <a class="nav-link <?php echo e($activeLocale == 'general' ? 'active' : ''); ?>" id="general-tab" data-toggle="tab" href="#general" role="tab" aria-controls="general" aria-selected="true">
      <?php echo e(__('main::lang.general')); ?></a>
    </li>
    <?php $__currentLoopData = $langs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lang): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
      <li class="nav-item">
        <a class="nav-link <?php echo e($activeLocale == $lang->locale ? 'active' : ''); ?>" id="<?php echo e($lang->locale); ?>-tab" data-toggle="tab" href="#<?php echo e($lang->locale); ?>"
          role="tab" aria-controls="<?php echo e($lang->locale); ?>" aria-selected="false">
          <?php echo e(__('main::lang.'. $lang->locale)); ?>

        </a>
      </li>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
  </ul>

  
  <div class="tab-content" id="langsTabsContent">
    <div class="tab-pane fade <?php echo e($activeLocale == 'general' ? 'show active' : ''); ?>" id="general" role="tabpanel" aria-labelledby="general-tab">
      <div class="row">
        <div class="col-lg-9">

          <div class="form-group row">
            <label class="col-md-3 col-form-label" for="daily_offers_code"><?php echo e(__('main::lang.daily_offers_code')); ?><span class="text-danger"> *</span></label>
            <div class="col-md-9">
              <input class="form-control <?php echo e($errors->first('daily_offers_code') ? 'is-invalid' : ''); ?>" id="daily_offers_code" type="text" name="daily_offers_code"
               placeholder="<?php echo e(__('main::lang.daily_offers_code')); ?>" value="<?php echo e(old('daily_offers_code', isset($daily_offer) ? $daily_offer->daily_offers_code : '')); ?>">
              <?php if($errors->first('daily_offers_code')): ?>
                <div class="invalid-feedback"><?php echo e($errors->first('daily_offers_code')); ?></div>
              <?php endif; ?>
            </div>
          </div>

          <div class="form-group row">
            <label class="col-md-3 col-form-label" for="stores_id"><?php echo e(__('main::lang.store')); ?><span class="text-danger"> *</span></label>
            <div class="col-md-9">
              <?php echo Form::select('stores_id', $stores, isset($daily_offer) ? $daily_offer->stores_id : null, ['class' => $errors->first('stores_id') ? 'form-control is-invalid' : 'form-control','placeholder'=>__('main::lang.store'),'id'=>'stores_id']); ?>

              <?php if($errors->first('stores_id')): ?>
                <div class="invalid-feedback"><?php echo e($errors->first('stores_id')); ?></div>
              <?php endif; ?>
            </div>
          </div>

          <div class="form-group row">
            <label class="col-md-3 col-form-label" for="currencies_id"><?php echo e(__('main::lang.currency')); ?><span class="text-danger"> *</span></label>
            <div class="col-md-9">
              <?php echo Form::select('currencies_id', $currencies, isset($daily_offer) ? $daily_offer->currencies_id : null, ['class' => $errors->first('currencies_id') ? 'form-control is-invalid' : 'form-control','placeholder'=>__('main::lang.currency'),'id'=>'currencies_id']); ?>

              <?php if($errors->first('currencies_id')): ?>
                <div class="invalid-feedback"><?php echo e($errors->first('currencies_id')); ?></div>
              <?php endif; ?>
            </div>
          </div>
   
          <div class="form-group row">
            <label class="col-md-3 col-form-label" for="daily_offers_url"><?php echo e(__('main::lang.daily_offers_url')); ?><span class="text-danger"> *</span></label>
            <div class="col-md-9">
              <input class="form-control <?php echo e($errors->first('daily_offers_url') ? 'is-invalid' : ''); ?>" id="daily_offers_url" type="text" name="daily_offers_url"
               placeholder="<?php echo e(__('main::lang.daily_offers_url')); ?>" value="<?php echo e(old('daily_offers_url', isset($daily_offer) ? $daily_offer->daily_offers_url : '')); ?>">
              <?php if($errors->first('daily_offers_url')): ?>
                <div class="invalid-feedback"><?php echo e($errors->first('daily_offers_url')); ?></div>
              <?php endif; ?>
            </div>
          </div>

          <div class="form-group row">
            <label class="col-md-3 col-form-label" for="daily_offers_price"><?php echo e(__('main::lang.daily_offers_price')); ?><span class="text-danger"> *</span></label>
            <div class="col-md-9">
              <input class="form-control <?php echo e($errors->first('daily_offers_price') ? 'is-invalid' : ''); ?>" id="daily_offers_price" type="number" min="0" step="0.01" name="daily_offers_price"
               placeholder="<?php echo e(__('main::lang.daily_offers_price')); ?>" value="<?php echo e(old('daily_offers_price', isset($daily_offer) ? $daily_offer->daily_offers_price : '')); ?>">
              <?php if($errors->first('daily_offers_price')): ?>
                <div class="invalid-feedback"><?php echo e($errors->first('daily_offers_price')); ?></div>
              <?php endif; ?>
            </div>
          </div>
          
          <div class="form-group row">
            <label class="col-md-3 col-form-label" for="daily_offers_price_before_sale"><?php echo e(__('main::lang.daily_offers_price_before_sale')); ?><span class="text-danger"> </span></label>
            <div class="col-md-9">
              <input class="form-control <?php echo e($errors->first('daily_offers_price_before_sale') ? 'is-invalid' : ''); ?>" id="daily_offers_price_before_sale" type="number" min="0" step="0.01" name="daily_offers_price_before_sale"
               placeholder="<?php echo e(__('main::lang.daily_offers_price_before_sale')); ?>" value="<?php echo e(old('daily_offers_price_before_sale', isset($daily_offer) ? $daily_offer->daily_offers_price_before_sale : '')); ?>">
              <?php if($errors->first('daily_offers_price_before_sale')): ?>
                <div class="invalid-feedback"><?php echo e($errors->first('daily_offers_price_before_sale')); ?></div>
              <?php endif; ?>
            </div>
          </div>

          <div class="form-group row">
            <label class="col-md-3 col-form-label" for="daily_offers_position"><?php echo e(__('main::lang.position')); ?><span class="text-danger"> *</span></label>
            <div class="col-md-9">
              <input class="form-control <?php echo e($errors->first('daily_offers_position') ? 'is-invalid' : ''); ?>" id="daily_offers_position" type="text" name="daily_offers_position"
               placeholder="<?php echo e(__('main::lang.position')); ?>" value="<?php echo e(old('daily_offers_position', isset($daily_offer) ? $daily_offer->daily_offers_position : 1)); ?>">
              <?php if($errors->first('daily_offers_position')): ?>
                <div class="invalid-feedback"><?php echo e($errors->first('daily_offers_position')); ?></div>
              <?php endif; ?>
            </div>
          </div>
          <div class="form-group row ">
            <label class="col-md-3 col-form-label" for="daily_offers_image"><?php echo e(__('main::lang.img')); ?><span class="text-danger">  </span></label>
            <div class="col-md-9">
              <?php echo $__env->make('main::layouts.includes.imagePreview', ['name' => 'daily_offers_image', 'value' => isset($daily_offer) ? $daily_offer->daily_offers_image : null,'type'=>'daily_offers'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
              <?php if($errors->first('daily_offers_image')): ?>
                <div class="invalid-feedback"><?php echo e($errors->first('daily_offers_image')); ?></div>
              <?php endif; ?>
            </div>
          </div>
          <div class="form-group row">
            <label class="col-md-3 col-form-label"><?php echo e(__('main::lang.status')); ?><span class="text-danger"> *</span></label>
            <div class="col-md-9 col-form-label">
              <?php
                $status = old('daily_offers_status', isset($daily_offer) ? $daily_offer->daily_offers_status : 1);
              ?>
              <input type="hidden" id="daily_offers_status_input" name="daily_offers_status" value="<?php echo e($status); ?>">
              <input type="checkbox" name="daily_offers_statuss" id="daily_offers_status"  <?php echo e($status ? 'checked' : ''); ?>  data-on=" <?php echo e(__('main::lang.active')); ?>" data-off=" <?php echo e(__('main::lang.stopped')); ?>" data-toggle="toggle" data-onstyle="success" data-offstyle="danger" data-width="80px" onChange="changeStatusInput('daily_offers')">

              <?php if($errors->first('daily_offers_status')): ?>
                <div class="invalid-feedback"><?php echo e($errors->first('daily_offers_status')); ?></div>
              <?php endif; ?>
            </div>
          </div>

        </div>
      </div>
    </div>
    
    <?php $__currentLoopData = $langs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lang): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
      <div class="tab-pane fade <?php echo e($activeLocale == $lang->locale ? 'show active' : ''); ?>" id="<?php echo e($lang->locale); ?>" role="tabpanel" aria-labelledby="<?php echo e($lang->locale); ?>-tab">

        <div class="row">

          <div class="col-lg-9">
            <p class="text-primary h6"><?php echo e(__('main::lang.daily_offerDetails')); ?></p>
            <div class="form-group row">
              <label class="col-md-2 col-form-label"><?php echo e(__('main::lang.desc')); ?><span class="text-danger"> *</span></label>

              <div class="col-md-10">
                <input class="form-control <?php echo e($errors->first($lang->locale .'.daily_offers_name') ? 'is-invalid' : ''); ?>" type="text"
                 name="<?php echo e($lang->locale .'[daily_offers_name]'); ?>" placeholder="<?php echo e(__('main::lang.desc')); ?>"
                 value="<?php echo e(old($lang->locale .'.daily_offers_name', isset($daily_offer) ? $daily_offer->translate($lang->locale)->daily_offers_name : '')); ?>">
                <?php if($errors->first($lang->locale .'.daily_offers_name')): ?>
                  <div class="invalid-feedback"><?php echo e($errors->first($lang->locale .'.daily_offers_name')); ?></div>
                <?php endif; ?>
              </div>
            </div>

          </div>
        </div>

      </div>
 
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
  </div>
</div>
 
<?php /**PATH /home/vivacoupon/public_html/system.vivacoupon.com/system/Modules/Main/Resources/views/admin/daily_offers/form.blade.php ENDPATH**/ ?>