
<?php
  $activeLocale = old('activeLocale', 'general');
  $activeLocale = 'general';
?>

<div class="card-body">
  <?php echo $__env->make('main::layouts.includes.messages', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

  
  <ul class="nav nav-tabs" id="langsTabs" role="tablist">
    <li class="nav-item">
      <a class="nav-link <?php echo e($activeLocale == 'general' ? 'active' : ''); ?>" id="general-tab" data-toggle="tab" href="#general" role="tab" aria-controls="general" aria-selected="true">
      <?php echo e(__('main::lang.general')); ?></a>
    </li>
    <?php $__currentLoopData = $langs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lang): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
      <li class="nav-item">
        <a class="nav-link <?php echo e($activeLocale == $lang->locale ? 'active' : ''); ?>" id="<?php echo e($lang->locale); ?>-tab" data-toggle="tab" href="#<?php echo e($lang->locale); ?>"
          role="tab" aria-controls="<?php echo e($lang->locale); ?>" aria-selected="false">
          <?php echo e(__('main::lang.'. $lang->locale)); ?>

        </a>
      </li>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
  </ul>

  
  <div class="tab-content" id="langsTabsContent">
    <div class="tab-pane fade <?php echo e($activeLocale == 'general' ? 'show active' : ''); ?>" id="general" role="tabpanel" aria-labelledby="general-tab">
      <div class="row">
        <div class="col-lg-9">

          <div class="form-group row">
            <label class="col-md-3 col-form-label" for="coupons_code"><?php echo e(__('main::lang.coupons_code')); ?><span class="text-danger"> *</span></label>
            <div class="col-md-9">
              <input class="form-control <?php echo e($errors->first('coupons_code') ? 'is-invalid' : ''); ?>" id="coupons_code" type="text" name="coupons_code"
               placeholder="<?php echo e(__('main::lang.coupons_code')); ?>" value="<?php echo e(old('coupons_code', isset($coupon) ? $coupon->coupons_code : '')); ?>">
              <?php if($errors->first('coupons_code')): ?>
                <div class="invalid-feedback"><?php echo e($errors->first('coupons_code')); ?></div>
              <?php endif; ?>
            </div>
          </div>

          <div class="form-group row">
            <label class="col-md-3 col-form-label" for="stores_id"><?php echo e(__('main::lang.store')); ?><span class="text-danger"> *</span></label>
            <div class="col-md-9">
              <?php echo Form::select('stores_id', $stores, isset($coupon) ? $coupon->stores_id : null, ['class' => $errors->first('stores_id') ? 'form-control is-invalid' : 'form-control','placeholder'=>__('main::lang.store'),'id'=>'stores_id']); ?>

              <?php if($errors->first('stores_id')): ?>
                <div class="invalid-feedback"><?php echo e($errors->first('stores_id')); ?></div>
              <?php endif; ?>
            </div>
          </div>

          <div class="form-group row">
            <label class="col-md-3 col-form-label" for="coupons_position"><?php echo e(__('main::lang.position')); ?><span class="text-danger"> *</span></label>
            <div class="col-md-9">
              <input class="form-control <?php echo e($errors->first('coupons_position') ? 'is-invalid' : ''); ?>" id="coupons_position" type="text" name="coupons_position"
               placeholder="<?php echo e(__('main::lang.position')); ?>" value="<?php echo e(old('coupons_position', isset($coupon) ? $coupon->coupons_position : 1)); ?>">
              <?php if($errors->first('coupons_position')): ?>
                <div class="invalid-feedback"><?php echo e($errors->first('coupons_position')); ?></div>
              <?php endif; ?>
            </div>
          </div>

          

          <div class="form-group row">
            <label class="col-md-3 col-form-label"><?php echo e(__('main::lang.status')); ?><span class="text-danger"> *</span></label>
            <div class="col-md-9 col-form-label">
              <?php
                $status = old('coupons_status', isset($coupon) ? $coupon->coupons_status : 1);
              ?>
              <input type="hidden" id="coupons_status_input" name="coupons_status" value="<?php echo e($status); ?>">
              <input type="checkbox" name="coupons_statuss" id="coupons_status"  <?php echo e($status ? 'checked' : ''); ?>  data-on=" <?php echo e(__('main::lang.active')); ?>" data-off=" <?php echo e(__('main::lang.stopped')); ?>" data-toggle="toggle" data-onstyle="success" data-offstyle="danger" data-width="80px" onChange="changeStatusInput('coupons')">

              <?php if($errors->first('coupons_status')): ?>
                <div class="invalid-feedback"><?php echo e($errors->first('coupons_status')); ?></div>
              <?php endif; ?>
            </div>
          </div>

          

          <div class="form-group row">
            <label class="col-md-3 col-form-label"><?php echo e(__('main::lang.is_special')); ?><span class="text-danger"> *</span></label>
            <div class="col-md-9 col-form-label">
              <?php
                $is_special = old('coupons_is_special', isset($coupon) ? $coupon->coupons_is_special : 1);
              ?>
              <input type="hidden" id="coupons_is_special_input" name="coupons_is_special" value="<?php echo e($is_special); ?>">
              <input type="checkbox" name="coupons_is_specials" id="coupons_is_special"  <?php echo e($is_special ? 'checked' : ''); ?>  data-on=" <?php echo e(__('main::lang.special')); ?>" data-off=" <?php echo e(__('main::lang.not_special')); ?>" data-toggle="toggle" data-onstyle="success" data-offstyle="danger" data-width="150px" onChange="changeToggleInput('coupons_is_special')">

              <?php if($errors->first('coupons_is_special')): ?>
                <div class="invalid-feedback"><?php echo e($errors->first('coupons_is_special')); ?></div>
              <?php endif; ?>
            </div>
          </div>

        </div>
      </div>
    </div>
    
    <?php $__currentLoopData = $langs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lang): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
      <div class="tab-pane fade <?php echo e($activeLocale == $lang->locale ? 'show active' : ''); ?>" id="<?php echo e($lang->locale); ?>" role="tabpanel" aria-labelledby="<?php echo e($lang->locale); ?>-tab">

        <div class="row">

          <div class="col-lg-9">
            <p class="text-primary h6"><?php echo e(__('main::lang.couponDetails')); ?></p>

            <div class="form-group row">
              <label class="col-md-2 col-form-label"><?php echo e(__('main::lang.coupons_name')); ?><span class="text-danger"> *</span></label>

              <div class="col-md-10">
                <input class="form-control <?php echo e($errors->first($lang->locale .'.coupons_name') ? 'is-invalid' : ''); ?>" type="text"
                 name="<?php echo e($lang->locale .'[coupons_name]'); ?>" placeholder="<?php echo e(__('main::lang.coupons_name')); ?>"
                 value="<?php echo e(old($lang->locale .'.coupons_name', isset($coupon) ? $coupon->translate($lang->locale)->coupons_name : '')); ?>">
                <?php if($errors->first($lang->locale .'.coupons_name')): ?>
                  <div class="invalid-feedback"><?php echo e($errors->first($lang->locale .'.coupons_name')); ?></div>
                <?php endif; ?>
              </div>
            </div>

            

            <div class="form-group row">
              <label class="col-md-2 col-form-label"><?php echo e(__('main::lang.coupons_desc')); ?><span class="text-danger"> </span></label>

              <div class="col-md-10">
                <textarea id="<?php echo e($lang->locale); ?>-ckeditor2" class="ckeditor form-control <?php echo e($errors->first($lang->locale .'.coupons_desc') ? 'is-invalid' : ''); ?>" type="text" rows="5" name="<?php echo e($lang->locale .'[coupons_desc]'); ?>" placeholder="<?php echo e(__('main::lang.coupons_desc')); ?>"><?php echo e(old($lang->locale .'.coupons_desc', isset($coupon) && $coupon->translate($lang->locale)  ? $coupon->translate($lang->locale)->coupons_desc : '')); ?></textarea>
                <?php if($errors->first($lang->locale .'.coupons_desc')): ?>
                  <div class="invalid-feedback"><?php echo e($errors->first($lang->locale .'.coupons_desc')); ?></div>
                <?php endif; ?>
              </div>
            </div>
            
            

          </div>
        </div>

      </div>
 
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
  </div>
</div>
 
<?php /**PATH /home/vivacoupon/public_html/system.vivacoupon.com/system/Modules/Main/Resources/views/admin/coupons/form.blade.php ENDPATH**/ ?>